/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.handler;

import betterwithmods.common.BWMItems;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class PortalHandler {
    @GameRegistry.ObjectHolder(value="minecraft:priest")
    public static VillagerRegistry.VillagerProfession PRIEST;

    @SubscribeEvent
    public void onScrollClick(PlayerInteractEvent.EntityInteractSpecific event) {
        World world = event.getWorld();
        EntityPlayer player = event.getEntityPlayer();
        Entity entity = event.getTarget();
        ItemStack tool = event.getItemStack();
        if (!entity.func_70027_ad() || tool.func_77973_b() != BWMItems.ARCANE_SCROLL) {
            return;
        }
        if (!(entity instanceof EntityVillager)) {
            return;
        }
        EntityVillager villager = (EntityVillager)entity;
        VillagerRegistry.VillagerProfession career = villager.getProfessionForge();
        if (career != PRIEST) {
            return;
        }
        event.setCanceled(true);
        if (world.field_72995_K) {
            return;
        }
        BlockPos pos = entity.func_180425_c();
        boolean success = PortalHandler.trySpawnPortal(world, pos);
        if (success) {
            world.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, villager.field_70165_t, villager.field_70163_u, villager.field_70161_v, 1.0, 0.0, 0.0, new int[0]);
            villager.func_70106_y();
        }
    }

    public static boolean trySpawnPortal(World worldIn, BlockPos pos) {
        Size sizeX = new Size(worldIn, pos, EnumFacing.Axis.X);
        if (sizeX.isValid() && sizeX.portalBlockCount == 0) {
            sizeX.placePortalBlocks();
            return true;
        }
        Size sizeZ = new Size(worldIn, pos, EnumFacing.Axis.Z);
        if (sizeZ.isValid() && sizeZ.portalBlockCount == 0) {
            sizeZ.placePortalBlocks();
            return true;
        }
        return false;
    }

    public static class Size {
        private final World world;
        private final EnumFacing.Axis axis;
        private final EnumFacing rightDir;
        private final EnumFacing leftDir;
        private int portalBlockCount;
        private BlockPos bottomLeft;
        private int height;
        private int width;
        private Block frame = Blocks.field_150475_bE;

        public Size(World world, BlockPos pos, EnumFacing.Axis axis) {
            this.world = world;
            this.axis = axis;
            if (axis == EnumFacing.Axis.X) {
                this.leftDir = EnumFacing.EAST;
                this.rightDir = EnumFacing.WEST;
            } else {
                this.leftDir = EnumFacing.NORTH;
                this.rightDir = EnumFacing.SOUTH;
            }
            BlockPos blockpos = pos;
            while (pos.func_177956_o() > blockpos.func_177956_o() - 21 && pos.func_177956_o() > 0 && this.isEmptyBlock(world.func_180495_p(pos.func_177977_b()))) {
                pos = pos.func_177977_b();
            }
            int i = this.getDistanceUntilEdge(pos, this.leftDir) - 1;
            if (i >= 0) {
                this.bottomLeft = pos.func_177967_a(this.leftDir, i);
                this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
                if (this.width < 2 || this.width > 21) {
                    this.bottomLeft = null;
                    this.width = 0;
                }
            }
            if (this.bottomLeft != null) {
                this.height = this.calculatePortalHeight();
            }
        }

        protected int getDistanceUntilEdge(BlockPos pos, EnumFacing facing) {
            BlockPos blockpos;
            int i;
            for (i = 0; i < 22 && this.isEmptyBlock(this.world.func_180495_p(blockpos = pos.func_177967_a(facing, i))) && this.world.func_180495_p(blockpos.func_177977_b()).func_177230_c() == this.frame; ++i) {
            }
            Block block = this.world.func_180495_p(pos.func_177967_a(facing, i)).func_177230_c();
            return block == this.frame ? i : 0;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        protected int calculatePortalHeight() {
            this.height = 0;
            block0: while (this.height < 21) {
                for (int i = 0; i < this.width; ++i) {
                    BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i).func_177981_b(this.height);
                    IBlockState blockState = this.world.func_180495_p(blockpos);
                    Block block = blockState.func_177230_c();
                    if (!this.isEmptyBlock(blockState)) break block0;
                    if (block == Blocks.field_150427_aO) {
                        ++this.portalBlockCount;
                    }
                    if (i == 0 ? (block = this.world.func_180495_p(blockpos.func_177972_a(this.leftDir)).func_177230_c()) != this.frame : i == this.width - 1 && (block = this.world.func_180495_p(blockpos.func_177972_a(this.rightDir)).func_177230_c()) != this.frame) break block0;
                }
                ++this.height;
            }
            for (int j = 0; j < this.width; ++j) {
                if (this.world.func_180495_p(this.bottomLeft.func_177967_a(this.rightDir, j).func_177981_b(this.height)).func_177230_c() == this.frame) continue;
                this.height = 0;
                break;
            }
            if (this.height <= 21 && this.height >= 3) {
                return this.height;
            }
            this.bottomLeft = null;
            this.width = 0;
            this.height = 0;
            return 0;
        }

        protected boolean isEmptyBlock(IBlockState state) {
            return state.func_185904_a() == Material.field_151579_a || state.func_177230_c() == Blocks.field_150480_ab || state.func_177230_c() == Blocks.field_150427_aO;
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
        }

        public void placePortalBlocks() {
            BlockPos blockpos;
            IBlockState portalState = Blocks.field_150427_aO.func_176223_P().func_177226_a((IProperty)BlockPortal.field_176550_a, (Comparable)this.axis);
            IBlockState frameState = Blocks.field_150343_Z.func_176223_P();
            for (int y = 0; y < this.height; ++y) {
                blockpos = this.bottomLeft.func_177981_b(y);
                this.world.func_180501_a(blockpos.func_177972_a(this.leftDir), frameState, 2);
                this.world.func_180501_a(blockpos.func_177967_a(this.rightDir, this.width), frameState, 2);
            }
            for (int i = 0; i < this.width; ++i) {
                blockpos = this.bottomLeft.func_177967_a(this.rightDir, i);
                this.world.func_180501_a(blockpos.func_177977_b(), frameState, 2);
                this.world.func_180501_a(blockpos.func_177981_b(this.height), frameState, 2);
                for (int j = 0; j < this.height; ++j) {
                    this.world.func_180501_a(blockpos.func_177981_b(j), portalState, 2);
                }
            }
        }
    }
}

