/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.interaction;

import betterwithaddons.BetterWithAddons;
import betterwithaddons.block.BlockWhiteBrick;
import betterwithaddons.block.ModBlocks;
import betterwithaddons.crafting.conditions.ConditionModule;
import betterwithaddons.interaction.Interaction;
import betterwithaddons.interaction.ModInteractions;
import betterwithaddons.item.ModItems;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWMItems;
import betterwithmods.common.BWRegistry;
import betterwithmods.common.blocks.BlockAesthetic;
import betterwithmods.common.items.ItemMaterial;
import betterwithmods.common.registry.block.recipe.BlockIngredient;
import betterwithmods.common.registry.block.recipe.KilnRecipe;
import betterwithmods.module.gameplay.AnvilRecipes;
import betterwithmods.module.gameplay.miniblocks.MiniBlockIngredient;
import betterwithmods.module.gameplay.miniblocks.MiniBlocks;
import betterwithmods.module.gameplay.miniblocks.MiniType;
import betterwithmods.module.tweaks.MossGeneration;
import betterwithmods.util.StackIngredient;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreIngredient;

public class InteractionDecoAddon
extends Interaction {
    public static boolean ENABLED = true;
    public static boolean WOOD_COLORING = true;
    public static boolean ALTERNATE_WROUGHT_BARS = true;
    public static boolean CHISEL_BRICKS_IN_ANVIL = true;
    public static boolean GLASS_PANE_REBALANCE = true;
    public static boolean GLASS_FURNACE = false;
    public static boolean CHEAPER_BOTTLES = true;
    public static boolean RECYCLE_BOTTLES = true;
    public static boolean MASON_MINIBLOCKS = true;
    public static boolean CLAY_MINIBLOCKS = true;

    @Override
    protected String getName() {
        return "addons.DecoAddon";
    }

    @Override
    void setupConfig() {
        ENABLED = this.loadPropBool("Enabled", "Whether the Deco Addon module is on. DISABLING THIS WILL DISABLE THE WHOLE MODULE.", ENABLED);
        WOOD_COLORING = this.loadPropBool("WoodColoring", "Vanilla planks can be bleached or stained.", WOOD_COLORING);
        ALTERNATE_WROUGHT_BARS = this.loadPropBool("AlternateWroughtBars", "Wrought bars are made at a ratio of 1 iron ingot per bar instead of 1/2 an iron ingot per bar.", ALTERNATE_WROUGHT_BARS);
        CHISEL_BRICKS_IN_ANVIL = this.loadPropBool("ChiselBricksInAnvil", "Chiseled Stone Bricks can only be crafted on a Steel Anvil.", CHISEL_BRICKS_IN_ANVIL);
        GLASS_PANE_REBALANCE = this.loadPropBool("GlassPaneRebalance", "Glass becomes neatly divisable into two glass panes per block.", GLASS_PANE_REBALANCE);
        GLASS_FURNACE = this.loadPropBool("GlassFurnace", "Glass chunks can be smelted in a furnace.", GLASS_FURNACE);
        CHEAPER_BOTTLES = this.loadPropBool("CheaperBottles", "Glass bottles are made from half as much glass as normal.", CHEAPER_BOTTLES);
        RECYCLE_BOTTLES = this.loadPropBool("RecycleBottles", "Glass bottles can melted into chunks in a crucible. This allows you to make glass from a witch farm.", RECYCLE_BOTTLES);
        MASON_MINIBLOCKS = this.loadPropBool("MasonMiniblocks", "Add some odd materials to miniblocks whitelist (WIP)", MASON_MINIBLOCKS);
        CLAY_MINIBLOCKS = this.loadPropBool("ClayMiniblocks", "Add all kinds of clay to miniblocks whitelist (WIP)", CLAY_MINIBLOCKS);
    }

    @Override
    public boolean isActive() {
        return ENABLED;
    }

    @Override
    public void setEnabled(boolean active) {
        ENABLED = active;
        super.setEnabled(active);
    }

    @Override
    public List<Interaction> getDependencies() {
        return Arrays.asList(ModInteractions.bwm);
    }

    @Override
    public List<Interaction> getIncompatibilities() {
        return null;
    }

    @Override
    public void preInit() {
        if (CLAY_MINIBLOCKS || MASON_MINIBLOCKS) {
            MiniBlocks.addMaterial((Material)Material.field_151571_B, (String)"clay");
            MiniBlocks.addMaterial((Material)Material.field_151578_c, (String)"ground");
        }
        ConditionModule.MODULES.put("DecoAddon", this::isActive);
        ConditionModule.MODULES.put("ChiselBricksInAnvil", () -> CHISEL_BRICKS_IN_ANVIL);
        ConditionModule.MODULES.put("CheaperBottles", () -> CHEAPER_BOTTLES);
        if (CHEAPER_BOTTLES) {
            BetterWithAddons.removeCraftingRecipe(new ResourceLocation("minecraft", "glass_bottle"));
        }
        if (CHISEL_BRICKS_IN_ANVIL) {
            BetterWithAddons.removeCraftingRecipe(new ResourceLocation("minecraft", "chiseled_stonebrick"));
        }
        if (CLAY_MINIBLOCKS) {
            MiniBlocks.addWhitelistedBlock((ResourceLocation)new ResourceLocation("minecraft:clay"));
            MiniBlocks.addWhitelistedBlock((ResourceLocation)new ResourceLocation("betterwithmods:nether_clay"));
            MiniBlocks.addWhitelistedBlock((ResourceLocation)new ResourceLocation("minecraft:hardened_clay"));
            MiniBlocks.addWhitelistedBlock((ResourceLocation)new ResourceLocation("minecraft:stained_hardened_clay"));
            MiniBlocks.addWhitelistedBlock((ResourceLocation)new ResourceLocation("betterwithmods:aesthetic"), (int)2);
        }
        if (MASON_MINIBLOCKS) {
            MiniBlocks.addWhitelistedBlock((ResourceLocation)new ResourceLocation("minecraft:obsidian"));
            MiniBlocks.addWhitelistedBlock((ResourceLocation)new ResourceLocation("betterwithmods:steel_block"), (int)0);
            MiniBlocks.addWhitelistedBlock((ResourceLocation)new ResourceLocation("betterwithmods:aesthetic"), (int)3);
            MiniBlocks.addWhitelistedBlock((ResourceLocation)new ResourceLocation("betterwithmods:aesthetic"), (int)10);
            MiniBlocks.addWhitelistedBlock((ResourceLocation)new ResourceLocation("betterwithmods:aesthetic"), (int)11);
        }
    }

    @Override
    public void init() {
        int glassout;
        BWRegistry.MILLSTONE.addMillRecipe((List)Lists.newArrayList((Object[])new Ingredient[]{StackIngredient.fromStacks((ItemStack[])new ItemStack[]{new ItemStack(BWMBlocks.HEMP, 1)}), Ingredient.func_193367_a((Item)Items.field_151069_bo)}), (List)Lists.newArrayList((Object[])new ItemStack[]{ModItems.MATERIAL_DECO.getMaterial("hemp_oil")}));
        BWRegistry.CAULDRON.addUnstokedRecipe((List)Lists.newArrayList((Object[])new Ingredient[]{StackIngredient.fromStacks((ItemStack[])new ItemStack[]{ModItems.MATERIAL_DECO.getMaterial("hemp_oil", 4)}), new OreIngredient("dyeWhite")}), (List)Lists.newArrayList((Object[])new ItemStack[]{ModItems.MATERIAL_DECO.getMaterial("wood_bleach", 4)}));
        BWRegistry.CAULDRON.addUnstokedRecipe((List)Lists.newArrayList((Object[])new Ingredient[]{StackIngredient.fromStacks((ItemStack[])new ItemStack[]{ModItems.MATERIAL_DECO.getMaterial("hemp_oil", 4)}), new OreIngredient("dyeBlack")}), (List)Lists.newArrayList((Object[])new ItemStack[]{ModItems.MATERIAL_DECO.getMaterial("wood_stain", 4)}));
        ItemStack chandelierLight = new ItemStack(Blocks.field_150478_aa);
        ItemStack ironLanternLight = ModItems.MATERIAL_DECO.getMaterial("hemp_oil");
        ItemStack woodLanternLight = ModItems.MATERIAL_DECO.getMaterial("hemp_oil");
        if (ALTERNATE_WROUGHT_BARS) {
            AnvilRecipes.addSteelShapedRecipe((ResourceLocation)new ResourceLocation("betterwithaddons", "wrought_bars"), (ItemStack)new ItemStack((Block)ModBlocks.WROUGHT_BARS, 8), (Object[])new Object[]{"bbbb", "bbbb", Character.valueOf('b'), new ItemStack(Blocks.field_150411_aY)});
        } else {
            AnvilRecipes.addSteelShapedRecipe((ResourceLocation)new ResourceLocation("betterwithaddons", "wrought_bars"), (ItemStack)new ItemStack((Block)ModBlocks.WROUGHT_BARS, 10), (Object[])new Object[]{"b b ", "bbbb", "b b ", "b b ", Character.valueOf('b'), "ingotIron"});
        }
        AnvilRecipes.addSteelShapedRecipe((ResourceLocation)new ResourceLocation("betterwithaddons", "chandelier"), (ItemStack)new ItemStack((Block)ModBlocks.CHANDELIER), (Object[])new Object[]{" ss ", " bb ", "tbbt", "tbbt", Character.valueOf('s'), "stone", Character.valueOf('b'), "nuggetGold", Character.valueOf('t'), "blockCandle"});
        ItemStack whiteBrick = new ItemStack((Block)ModBlocks.WHITE_BRICK, 1, BlockWhiteBrick.EnumType.DEFAULT.getMetadata());
        ItemStack whiteBrick_mossy = new ItemStack((Block)ModBlocks.WHITE_BRICK, 1, BlockWhiteBrick.EnumType.MOSSY.getMetadata());
        ItemStack whiteBrick_cracked = new ItemStack((Block)ModBlocks.WHITE_BRICK, 1, BlockWhiteBrick.EnumType.CRACKED.getMetadata());
        MossGeneration.addBlockConversion((Block)ModBlocks.WHITE_BRICK, (IBlockState)ModBlocks.WHITE_BRICK.func_176223_P().func_177226_a(BlockWhiteBrick.VARIANT, (Comparable)((Object)BlockWhiteBrick.EnumType.MOSSY)));
        if (CHISEL_BRICKS_IN_ANVIL) {
            AnvilRecipes.addSteelShapedRecipe((ResourceLocation)new ResourceLocation("betterwithaddons", "stone_brick_chiseled"), (ItemStack)new ItemStack(Blocks.field_150417_aV, 3, BlockStoneBrick.EnumType.CHISELED.func_176612_a()), (Object[])new Object[]{"bbbb", "b  b", "b  b", "bbbb", Character.valueOf('b'), new ItemStack(Blocks.field_150417_aV, 1, BlockStoneBrick.EnumType.DEFAULT.func_176612_a())});
            AnvilRecipes.addSteelShapedRecipe((ResourceLocation)new ResourceLocation("betterwithaddons", "white_brick_chiseled"), (ItemStack)new ItemStack((Block)ModBlocks.WHITE_BRICK, 3, BlockWhiteBrick.EnumType.CHISELED.getMetadata()), (Object[])new Object[]{"bbbb", "b  b", "b  b", "bbbb", Character.valueOf('b'), new ItemStack((Block)ModBlocks.WHITE_BRICK, 1, BlockWhiteBrick.EnumType.DEFAULT.getMetadata())});
        }
        FurnaceRecipes.func_77602_a().func_151394_a(whiteBrick, whiteBrick_cracked, 0.1f);
        BWRegistry.CAULDRON.addStokedRecipe((List)Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Blocks.field_150351_n)}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.NETHER_SLUDGE)})}), (List)Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Block)ModBlocks.PAVEMENT)}));
        int glasspanein = GLASS_PANE_REBALANCE ? 2 : 8;
        int n = glassout = GLASS_PANE_REBALANCE ? 1 : 3;
        if (GLASS_PANE_REBALANCE) {
            this.modifyPaneRecipe();
            BWRegistry.CRUCIBLE.remove((List)Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(Blocks.field_150359_w, 3)}));
        }
        BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(BWMItems.SAND_PILE, 1), ModItems.MATERIAL_DECO.getMaterial("glass_chunk"));
        BWRegistry.CRUCIBLE.addStokedRecipe(ModItems.MATERIAL_DECO.getMaterial("glass_chunk", 4), new ItemStack(Blocks.field_150359_w, 1));
        if (GLASS_FURNACE) {
            GameRegistry.addSmelting((ItemStack)new ItemStack(BWMItems.SAND_PILE, 1), (ItemStack)ModItems.MATERIAL_DECO.getMaterial("glass_chunk"), (float)0.02f);
            GameRegistry.addSmelting((ItemStack)ModItems.MATERIAL_DECO.getMaterial("glass_chunk", 4), (ItemStack)new ItemStack(Blocks.field_150359_w, 1), (float)0.05f);
        }
        if (RECYCLE_BOTTLES) {
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Items.field_151069_bo, 1), ModItems.MATERIAL_DECO.getMaterial("glass_chunk", CHEAPER_BOTTLES ? 2 : 4));
        }
        BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Blocks.field_150410_aZ, glasspanein), new ItemStack(Blocks.field_150359_w, glassout));
        for (EnumDyeColor dye : EnumDyeColor.values()) {
            ItemStack glass = new ItemStack((Block)Blocks.field_150399_cn, glassout, dye.func_176765_a());
            ItemStack glasspane = new ItemStack((Block)Blocks.field_150397_co, glasspanein, dye.func_176765_a());
            BWRegistry.CRUCIBLE.addStokedRecipe(glasspane, glass);
        }
        if (WOOD_COLORING) {
            ItemStack birch = new ItemStack(Blocks.field_150344_f, 1, BlockPlanks.EnumType.BIRCH.func_176839_a());
            ItemStack oak = new ItemStack(Blocks.field_150344_f, 1, BlockPlanks.EnumType.OAK.func_176839_a());
            ItemStack jungle_wood = new ItemStack(Blocks.field_150344_f, 1, BlockPlanks.EnumType.JUNGLE.func_176839_a());
            ItemStack acacia = new ItemStack(Blocks.field_150344_f, 1, BlockPlanks.EnumType.ACACIA.func_176839_a());
            ItemStack spruce = new ItemStack(Blocks.field_150344_f, 1, BlockPlanks.EnumType.SPRUCE.func_176839_a());
            ItemStack darkoak = new ItemStack(Blocks.field_150344_f, 1, BlockPlanks.EnumType.DARK_OAK.func_176839_a());
            this.addStainingRecipe(birch, oak);
            this.addStainingRecipe(oak, jungle_wood);
            this.addStainingRecipe(jungle_wood, acacia);
            this.addStainingRecipe(acacia, spruce);
            this.addStainingRecipe(spruce, darkoak);
        }
        if (CLAY_MINIBLOCKS) {
            this.addMiniBlockKilnRecipe(new ItemStack(Blocks.field_150435_aG), Blocks.field_150405_ch.func_176223_P());
            this.addMiniBlockKilnRecipe(new ItemStack(BWMBlocks.NETHER_CLAY), BlockAesthetic.getVariant((BlockAesthetic.EnumType)BlockAesthetic.EnumType.NETHERCLAY));
        }
        if (MASON_MINIBLOCKS) {
            MiniBlocks.MATERIALS.put((Object)Material.field_151573_f, (Object)BWMBlocks.STEEL_BLOCK.func_176223_P());
            BWRegistry.CRUCIBLE.addStokedRecipe((Ingredient)new MiniBlockIngredient("siding", new ItemStack(BWMBlocks.STEEL_BLOCK)), ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.INGOT_STEEL, (int)8));
            BWRegistry.CRUCIBLE.addStokedRecipe((Ingredient)new MiniBlockIngredient("moulding", new ItemStack(BWMBlocks.STEEL_BLOCK)), ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.INGOT_STEEL, (int)4));
            BWRegistry.CRUCIBLE.addStokedRecipe((Ingredient)new MiniBlockIngredient("corner", new ItemStack(BWMBlocks.STEEL_BLOCK)), ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.INGOT_STEEL, (int)2));
        }
    }

    private void addMiniBlockKilnRecipe(ItemStack stackIn, IBlockState stateOut) {
        for (MiniType type : MiniType.VALUES) {
            HashMap materialBlocks = (HashMap)MiniBlocks.MINI_MATERIAL_BLOCKS.get(type);
            if (materialBlocks == null) continue;
            ItemStack output = MiniBlocks.fromParent((Block)((Block)materialBlocks.get(stateOut.func_185904_a())), (IBlockState)stateOut, (int)1);
            BWRegistry.KILN.addRecipe(new KilnRecipe((BlockIngredient)new MiniBlockIngredient(type.name(), stackIn), (List)Lists.newArrayList((Object[])new ItemStack[]{output}), 2));
        }
    }

    @Override
    public void postInit() {
    }

    public void modifyPaneRecipe() {
        for (IRecipe recipe : CraftingManager.field_193380_a) {
            ItemStack output = recipe.func_77571_b();
            Block block = Block.func_149634_a((Item)output.func_77973_b());
            if (block != Blocks.field_150410_aZ && block != Blocks.field_150397_co) continue;
            output.func_190920_e(output.func_190916_E() * 3 / 4);
        }
    }

    public void addStainingRecipe(ItemStack lighter, ItemStack darker) {
        ItemStack emptyBottle = new ItemStack(Items.field_151069_bo, 1);
        BWRegistry.CAULDRON.addUnstokedRecipe((List)Lists.newArrayList((Object[])new Ingredient[]{StackIngredient.fromStacks((ItemStack[])new ItemStack[]{lighter}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ModItems.MATERIAL_DECO.getMaterial("wood_stain")})}), (List)Lists.newArrayList((Object[])new ItemStack[]{darker, emptyBottle}));
        BWRegistry.CAULDRON.addUnstokedRecipe((List)Lists.newArrayList((Object[])new Ingredient[]{StackIngredient.fromStacks((ItemStack[])new ItemStack[]{darker}), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ModItems.MATERIAL_DECO.getMaterial("wood_bleach")})}), (List)Lists.newArrayList((Object[])new ItemStack[]{lighter, emptyBottle}));
    }
}

