/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.interaction.jei.category;

import betterwithaddons.interaction.jei.wrapper.SmeltingRecipeWrapper;
import betterwithaddons.item.ModItems;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class TataraRecipeCategory
extends BlankRecipeCategory<SmeltingRecipeWrapper> {
    public static final String UID = "bwa.tatara";
    @Nonnull
    private final IDrawable background;
    @Nonnull
    private final IDrawable flame;
    @Nonnull
    private final IDrawable arrow;
    @Nonnull
    private final String localizedName;

    public TataraRecipeCategory(IGuiHelper helper) {
        ResourceLocation location = new ResourceLocation("betterwithaddons", "textures/gui/tatara.png");
        this.background = helper.createDrawable(location, 55, 16, 82, 54);
        IDrawableStatic flameDrawable = helper.createDrawable(location, 176, 0, 14, 14);
        this.flame = helper.createAnimatedDrawable(flameDrawable, 300, IDrawableAnimated.StartDirection.TOP, true);
        IDrawableStatic arrowDrawable = helper.createDrawable(location, 176, 14, 24, 17);
        this.arrow = helper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.localizedName = Translator.translateToLocal((String)"inv.tatara.name");
    }

    public void drawExtras(Minecraft minecraft) {
        this.flame.draw(minecraft, 2, 20);
        this.arrow.draw(minecraft, 24, 18);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, SmeltingRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 0);
        guiItemStacks.init(1, true, 0, 36);
        guiItemStacks.init(2, false, 60, 18);
        guiItemStacks.set(0, recipeWrapper.getInputs());
        guiItemStacks.set(1, ModItems.MATERIAL_JAPAN.getMaterial("rice_ash"));
        guiItemStacks.set(2, recipeWrapper.getOutputs());
    }

    public String getModName() {
        return "Better With Addons";
    }
}

