/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.interaction.minetweaker;

import betterwithaddons.crafting.manager.CraftingManagerSpindle;
import betterwithaddons.crafting.recipes.SpindleRecipe;
import betterwithaddons.util.IngredientCraftTweaker;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.CraftTweaker;
import java.util.List;
import stanhebben.zenscript.annotations.NotNull;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.betterwithaddons.Spindle")
public class Spindle {
    public static final String clazz = "mods.betterwithaddons.Spindle";

    @ZenMethod
    public static void add(IItemStack[] outputs, @NotNull IIngredient input, boolean consumesSpindle) {
        SpindleRecipe r = new SpindleRecipe(consumesSpindle, new IngredientCraftTweaker(input), CraftTweakerMC.getItemStacks((IItemStack[])outputs));
        CraftTweaker.LATE_ACTIONS.add(new Add(r));
    }

    @ZenMethod
    public static void remove(IItemStack input) {
        CraftTweaker.LATE_ACTIONS.add(new Remove(input));
    }

    public static class Remove
    implements IAction {
        IItemStack stack;

        public Remove(IItemStack stack) {
            this.stack = stack;
        }

        public void apply() {
            List<SpindleRecipe> recipes = CraftingManagerSpindle.getInstance().findRecipeForRemoval(CraftTweakerMC.getItemStack((IItemStack)this.stack));
            CraftingManagerSpindle.getInstance().getRecipes().removeAll(recipes);
        }

        public String describe() {
            return "Removing Spindle recipe for " + this.stack.getDisplayName();
        }
    }

    public static class Add
    implements IAction {
        SpindleRecipe recipe;

        public Add(SpindleRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            CraftingManagerSpindle.getInstance().addRecipe(this.recipe);
        }

        public String describe() {
            return "Adding Drying Unit recipe:" + this.recipe.toString();
        }
    }
}

