/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.item;

import betterwithaddons.block.ColorHandlers;
import betterwithaddons.block.IColorable;
import betterwithaddons.util.TeaType;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.translation.I18n;

public class ItemTea
extends Item
implements IColorable {
    TeaType.ItemType itemType;

    public ItemTea(TeaType.ItemType itemType) {
        this.itemType = itemType;
    }

    public ItemStack getStack(TeaType type) {
        return this.getStack(type, 1);
    }

    public ItemStack getStack(TeaType type, int n) {
        ItemStack stack = new ItemStack((Item)this, n);
        stack.func_77983_a("type", (NBTBase)new NBTTagString(type.getName()));
        return stack;
    }

    public static TeaType getType(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null) {
            return TeaType.getType(compound.func_74779_i("type"));
        }
        return TeaType.WHITE;
    }

    public static TeaType.ItemType getItemType(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item instanceof ItemTea ? ((ItemTea)item).itemType : TeaType.ItemType.Leaves;
    }

    public int getColor(ItemStack stack) {
        TeaType type = ItemTea.getType(stack);
        switch (this.itemType) {
            case Leaves: {
                return type.getLeafColor();
            }
            case Soaked: {
                return type.getSoakedColor();
            }
            case Wilted: {
                return type.getWiltedColor();
            }
            case Powder: {
                return type.getPowderColor();
            }
        }
        return 0xFFFFFF;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.addAll((Collection)TeaType.getTypesByItem(this.itemType).stream().map(this::getStack).collect(Collectors.toList()));
        }
    }

    public String func_77653_i(ItemStack stack) {
        TeaType type = ItemTea.getType(stack);
        return I18n.func_74837_a((String)(super.func_77667_c(stack) + ".name"), (Object[])new Object[]{I18n.func_74838_a((String)("tea.type." + type.getName()))});
    }

    @Override
    public IBlockColor getBlockColor() {
        return null;
    }

    @Override
    public IItemColor getItemColor() {
        return ColorHandlers.TEA_ITEM_COLORING;
    }
}

