/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.tileentity;

import betterwithaddons.lib.IRedstoneSensitive;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TileEntityBase
extends TileEntity {
    private ItemStackHandler inventoryHandler;
    private boolean redstonePowered;

    protected void setItemHandler(ItemStackHandler handler) {
        this.inventoryHandler = handler;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.writeDataToNBT(compound);
        if (this.inventoryHandler != null) {
            NBTTagCompound inventoryCompound = this.inventoryHandler.serializeNBT();
            compound.func_74782_a("inventory", (NBTBase)inventoryCompound);
        }
        if (this instanceof IRedstoneSensitive) {
            compound.func_74757_a("redstonePowered", this.redstonePowered);
        }
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readDataFromNBT(compound);
        if (this.inventoryHandler != null) {
            this.inventoryHandler.deserializeNBT(compound.func_74775_l("inventory"));
        }
        if (this instanceof IRedstoneSensitive) {
            this.redstonePowered = compound.func_74767_n("redstonePowered");
        }
    }

    public final void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        if (this.writeNBTToDescriptionPacket()) {
            this.readDataFromNBT(packet.func_148857_g());
        }
        if (this.renderAfterData()) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound baseCompound = super.func_189517_E_();
        if (this.writeNBTToDescriptionPacket()) {
            this.writeDataToNBT(baseCompound);
        }
        return baseCompound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        if (this.writeNBTToDescriptionPacket()) {
            this.writeDataToNBT(nbtTag);
        }
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, nbtTag);
    }

    public void syncTE() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public abstract void writeDataToNBT(NBTTagCompound var1);

    public abstract void readDataFromNBT(NBTTagCompound var1);

    public boolean renderAfterData() {
        return false;
    }

    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock) {
        boolean changed;
        boolean newPowered = this.field_145850_b.func_175687_A(this.field_174879_c) > 0;
        boolean bl = changed = this.redstonePowered != newPowered;
        if (changed) {
            ((IRedstoneSensitive)((Object)this)).redstoneChange(this.redstonePowered, newPowered);
            this.redstonePowered = newPowered;
            this.func_70296_d();
        }
    }

    public boolean writeNBTToDescriptionPacket() {
        return true;
    }

    protected boolean isPoweredByRedstone() {
        return this.redstonePowered;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.inventoryHandler != null) {
            return (T)this.inventoryHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.inventoryHandler != null || super.hasCapability(capability, facing);
    }
}

