/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.tileentity;

import betterwithaddons.block.BlockChute;
import betterwithaddons.block.ModBlocks;
import betterwithaddons.tileentity.SimpleItemStackHandler;
import betterwithaddons.tileentity.TileEntityBase;
import betterwithaddons.util.InventoryUtil;
import betterwithmods.api.BWMAPI;
import betterwithmods.api.tile.IMechanicalPower;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityChute
extends TileEntityBase
implements ITickable,
IMechanicalPower {
    public SimpleItemStackHandler inventory = this.createItemStackHandler();
    boolean[] blockedOutputs = new boolean[4];
    public byte power;
    int ejectCounter = 0;
    EnumFacing ejectDir = EnumFacing.NORTH;

    public SimpleItemStackHandler createItemStackHandler() {
        return new SimpleItemStackHandler(this, true, 18);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (facing == EnumFacing.UP && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing == EnumFacing.UP && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.inventory);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound) {
        compound.func_179237_a(this.inventory.serializeNBT());
        compound.func_74768_a("EjectDirection", this.ejectDir.func_176736_b());
        compound.func_74768_a("EjectCounter", this.ejectCounter);
        compound.func_74757_a("IsPowered", this.power > 1);
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound) {
        this.inventory = this.createItemStackHandler();
        this.inventory.deserializeNBT(compound);
        if (compound.func_74764_b("EjectDirection")) {
            this.ejectDir = EnumFacing.func_176731_b((int)compound.func_74762_e("EjectDirection"));
        }
        if (compound.func_74764_b("EjectCounter")) {
            this.ejectCounter = compound.func_74762_e("EjectCounter");
        }
        if (compound.func_74764_b("IsPowered")) {
            this.power = compound.func_74767_n("IsPowered") ? (byte)1 : 0;
        }
    }

    public static boolean putDropInInventoryAllSlots(IItemHandler inv, EntityItem entityItem) {
        boolean putAll = false;
        if (entityItem == null) {
            return false;
        }
        ItemStack itemstack = entityItem.func_92059_d().func_77946_l();
        ItemStack leftovers = TileEntityChute.attemptToInsert(inv, itemstack);
        if (!leftovers.func_190926_b() && leftovers.func_190916_E() != 0) {
            entityItem.func_92058_a(leftovers);
        } else {
            putAll = true;
            entityItem.func_70106_y();
        }
        return putAll;
    }

    public static ItemStack attemptToInsert(IItemHandler inv, ItemStack stack) {
        ItemStack leftover = ItemStack.field_190927_a;
        for (int slot = 0; slot < inv.getSlots() - 1 && !(leftover = inv.insertItem(slot, stack, false)).func_190926_b(); ++slot) {
        }
        return leftover;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!(state.func_177230_c() instanceof BlockChute)) {
            return;
        }
        this.entityCollision();
        boolean isOn = this.calculateInput() > 0;
        this.power = (byte)(isOn ? 1 : 0);
        if (!this.areAllOutputsBlocked()) {
            ++this.ejectCounter;
            if (this.ejectCounter > 2) {
                this.attemptToEjectStackFromInv(isOn);
                this.ejectCounter = 0;
            }
        } else {
            this.ejectCounter = 0;
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.func_145831_w() != null) {
            // empty if block
        }
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        int z;
        int y;
        int x = this.field_174879_c.func_177958_n();
        return player.func_70092_e((double)x + 0.5, (double)(y = this.field_174879_c.func_177956_o()) + 0.5, (double)(z = this.field_174879_c.func_177952_p()) + 0.5) <= 64.0;
    }

    public List<EntityItem> getCaptureItems(World worldIn, BlockPos pos) {
        return worldIn.func_175647_a(EntityItem.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)pos.func_177958_n() + 1.0, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 1.0), EntitySelectors.field_94557_a);
    }

    private void rotateToNextOutput(boolean powered, Random rand) {
        ArrayList<EnumFacing> validfacings = null;
        if (!powered) {
            validfacings = new ArrayList<EnumFacing>(4);
        }
        for (int i = 0; i < this.blockedOutputs.length; ++i) {
            this.ejectDir = this.ejectDir.func_176732_a(EnumFacing.Axis.Y);
            if (this.getOutputBlocked(this.ejectDir)) continue;
            if (powered) {
                return;
            }
            validfacings.add(this.ejectDir);
        }
        if (!powered && validfacings.size() > 0) {
            this.ejectDir = (EnumFacing)validfacings.get(rand.nextInt(validfacings.size()));
        }
    }

    private boolean isFull() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack itemstack = this.inventory.getStackInSlot(i);
            if (!itemstack.func_190926_b() && itemstack.func_190916_E() == itemstack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    private void entityCollision() {
        boolean flag = false;
        if (!this.isFull()) {
            flag = this.captureDroppedItems();
        }
        if (flag) {
            this.func_70296_d();
        }
    }

    private boolean captureDroppedItems() {
        List<EntityItem> items = this.getCaptureItems(this.func_145831_w(), this.func_174877_v());
        if (items.size() > 0) {
            boolean flag = false;
            for (EntityItem item : items) {
                flag = TileEntityChute.putDropInInventoryAllSlots((IItemHandler)this.inventory, item) || flag;
                if (!flag) continue;
                this.func_145831_w().func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((this.func_145831_w().field_73012_v.nextFloat() - this.func_145831_w().field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
            if (flag) {
                this.func_145831_w().func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((this.func_145831_w().field_73012_v.nextFloat() - this.func_145831_w().field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                return true;
            }
        }
        return false;
    }

    private void attemptToEjectStackFromInv(boolean powered) {
        int stackIndex = InventoryUtil.getFirstOccupiedStackInRange((IItemHandler)this.inventory, 0, 17);
        if (stackIndex > -1 && stackIndex < 18) {
            ItemStack invStack = this.inventory.getStackInSlot(stackIndex);
            int ejectStackSize = 1;
            ItemStack ejectStack = new ItemStack(invStack.func_77973_b(), ejectStackSize, invStack.func_77952_i());
            InventoryUtil.copyTags(ejectStack, invStack);
            BlockPos ejectpos = this.field_174879_c.func_177972_a(this.ejectDir);
            boolean ejectIntoWorld = false;
            if (!this.getOutputBlocked(this.ejectDir)) {
                if (this.func_145831_w().func_175623_d(ejectpos)) {
                    ejectIntoWorld = true;
                } else if (this.func_145831_w().func_180495_p(ejectpos).func_177230_c().func_176200_f((IBlockAccess)this.func_145831_w(), ejectpos)) {
                    ejectIntoWorld = true;
                } else {
                    Block block = this.func_145831_w().func_180495_p(ejectpos).func_177230_c();
                    if (block == null || !this.field_145850_b.isSideSolid(ejectpos, this.ejectDir.func_176734_d()) && (this.func_145831_w().func_175625_s(ejectpos) == null || !this.func_145831_w().func_175625_s(ejectpos).hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.ejectDir.func_176734_d()))) {
                        ejectIntoWorld = true;
                    } else if (powered) {
                        TileEntity tile = this.func_145831_w().func_175625_s(ejectpos);
                        if (tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.ejectDir.func_176734_d())) {
                            IItemHandler below = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.ejectDir.func_176734_d());
                            for (int slot = 0; slot < below.getSlots(); ++slot) {
                                ItemStack leftover = below.insertItem(slot, ejectStack, false);
                                if (!leftover.func_190926_b()) continue;
                                this.inventory.extractItem(stackIndex, ejectStackSize, false);
                                break;
                            }
                        } else {
                            this.setOutputBlocked(this.ejectDir, true);
                        }
                    } else {
                        this.setOutputBlocked(this.ejectDir, true);
                    }
                }
            }
            if (ejectIntoWorld) {
                this.ejectStack(ejectStack, this.ejectDir);
                this.inventory.extractItem(stackIndex, ejectStackSize, false);
            }
            this.rotateToNextOutput(powered, this.field_145850_b.field_73012_v);
        }
    }

    private void ejectStack(ItemStack stack, EnumFacing facing) {
        float xEject = facing.func_82601_c();
        float zEject = facing.func_82599_e();
        float xOff = this.func_145831_w().field_73012_v.nextFloat() * 0.05f + 0.475f + xEject * 0.7f;
        float yOff = 0.1f;
        float zOff = this.func_145831_w().field_73012_v.nextFloat() * 0.05f + 0.475f + zEject * 0.7f;
        EntityItem item = new EntityItem(this.func_145831_w(), (double)((float)this.field_174879_c.func_177958_n() + xOff), (double)((float)this.field_174879_c.func_177956_o() + yOff), (double)((float)this.field_174879_c.func_177952_p() + zOff), stack);
        item.field_70159_w = xEject * 0.1f;
        item.field_70181_x = 0.0;
        item.field_70179_y = zEject * 0.1f;
        item.func_174869_p();
        this.func_145831_w().func_72838_d((Entity)item);
    }

    public void resetOutputBlocked() {
        for (int i = 0; i < this.blockedOutputs.length; ++i) {
            this.blockedOutputs[i] = false;
        }
    }

    public void setOutputBlocked(EnumFacing facing, boolean blocked) {
        if (facing.func_176736_b() != -1) {
            this.blockedOutputs[facing.func_176736_b()] = blocked;
        }
    }

    public boolean getOutputBlocked(EnumFacing facing) {
        if (facing.func_176736_b() != -1) {
            return this.blockedOutputs[facing.func_176736_b()];
        }
        return true;
    }

    public boolean areAllOutputsBlocked() {
        for (boolean blocked : this.blockedOutputs) {
            if (blocked) continue;
            return false;
        }
        return true;
    }

    public int getMechanicalOutput(EnumFacing facing) {
        return -1;
    }

    public int getMechanicalInput(EnumFacing facing) {
        if (facing == EnumFacing.DOWN) {
            return BWMAPI.IMPLEMENTATION.getPowerOutput(this.field_145850_b, this.field_174879_c.func_177972_a(facing), facing.func_176734_d());
        }
        return 0;
    }

    public int getMaximumInput(EnumFacing facing) {
        return 1;
    }

    public int getMinimumInput(EnumFacing facing) {
        return 0;
    }

    public Block getBlock() {
        return ModBlocks.CHUTE;
    }

    public World getBlockWorld() {
        return this.func_145831_w();
    }

    public BlockPos getBlockPos() {
        return this.func_174877_v();
    }
}

