/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.tileentity;

import betterwithaddons.crafting.manager.CraftingManagerTatara;
import betterwithaddons.crafting.recipes.SmeltingRecipe;
import betterwithaddons.item.ModItems;
import betterwithaddons.tileentity.SimpleItemStackHandler;
import betterwithaddons.tileentity.TileEntityBase;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityTatara
extends TileEntityBase
implements ITickable {
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    public int cookTime;
    public int totalCookTime;
    public SimpleItemStackHandler inventory = this.createItemStackHandler();

    public SimpleItemStackHandler createItemStackHandler() {
        return new SimpleItemStackHandler(this, true, 3);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.inventory);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound) {
        compound.func_179237_a(this.inventory.serializeNBT());
        compound.func_74768_a("BurnTime", this.furnaceBurnTime);
        compound.func_74768_a("CookTime", this.cookTime);
        compound.func_74768_a("CookTimeTotal", this.totalCookTime);
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound) {
        this.inventory = this.createItemStackHandler();
        this.inventory.deserializeNBT(compound);
        this.furnaceBurnTime = compound.func_74762_e("BurnTime");
        this.cookTime = compound.func_74762_e("CookTime");
        this.totalCookTime = compound.func_74762_e("CookTimeTotal");
        this.currentItemBurnTime = TileEntityTatara.getItemBurnTime(this.inventory.getStackInSlot(1));
    }

    public boolean isValidStructure() {
        for (int z = -1; z <= 1; ++z) {
            for (int x = -1; x <= 1; ++x) {
                IBlockState upperstate = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(x, 1, z));
                if (!this.isTopping(upperstate)) {
                    return false;
                }
                if (!(z == x && x == 0 || this.isBedding(this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(x, -1, z))))) {
                    return false;
                }
                if (Math.abs(x) != Math.abs(z) || x == 0 || this.isStoneBrick(this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(x, 0, z)))) continue;
                return false;
            }
        }
        boolean hasSiding = this.isSiding(this.field_145850_b.func_180495_p(this.field_174879_c.func_177978_c())) && this.isSiding(this.field_145850_b.func_180495_p(this.field_174879_c.func_177968_d()));
        return this.isHeatSource(this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b())) && (hasSiding ^= this.isSiding(this.field_145850_b.func_180495_p(this.field_174879_c.func_177974_f())) && this.isSiding(this.field_145850_b.func_180495_p(this.field_174879_c.func_177976_e())));
    }

    public boolean isSiding(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150339_S;
    }

    public boolean isBedding(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150435_aG;
    }

    public boolean isTopping(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150385_bj;
    }

    public boolean isStoneBrick(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150417_aV;
    }

    public boolean isHeatSource(IBlockState state) {
        return state.func_185904_a() == Material.field_151587_i || state.func_185904_a() == Material.field_151581_o;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77969_a(ModItems.MATERIAL_JAPAN.getMaterial("rice_ash"))) {
            return 1600;
        }
        return 0;
    }

    public static boolean isItemFuel(ItemStack stack) {
        return TileEntityTatara.getItemBurnTime(stack) > 0;
    }

    public int getCookProgressScaled(int width) {
        return this.totalCookTime != 0 && this.cookTime != 0 ? this.cookTime * width / this.totalCookTime : 0;
    }

    public int getBurnLeftScaled(int height) {
        return this.currentItemBurnTime != 0 ? this.furnaceBurnTime * height / this.currentItemBurnTime : 0;
    }

    public int getCookTime(ItemStack stack) {
        return 1000;
    }

    private boolean canSmelt() {
        ItemStack inputstack = this.inventory.getStackInSlot(0);
        ItemStack outputstack = this.inventory.getStackInSlot(2);
        SmeltingRecipe recipe = CraftingManagerTatara.instance().getSmeltingRecipe(inputstack);
        if (inputstack.func_190926_b() || recipe == null) {
            return false;
        }
        ItemStack itemstack = recipe.getOutput(inputstack);
        if (itemstack.func_190926_b()) {
            return false;
        }
        if (outputstack.func_190926_b()) {
            return true;
        }
        if (!outputstack.func_77969_a(itemstack)) {
            return false;
        }
        int result = outputstack.func_190916_E() + itemstack.func_190916_E();
        return result <= this.getInventoryStackLimit() && result <= outputstack.func_77976_d();
    }

    public void smeltItem() {
        SmeltingRecipe recipe;
        ItemStack inputstack = this.inventory.getStackInSlot(0);
        ItemStack outputstack = this.inventory.getStackInSlot(2);
        if (this.canSmelt() && (recipe = CraftingManagerTatara.instance().getSmeltingRecipe(inputstack)) != null) {
            ItemStack itemstack = recipe.getOutput(inputstack);
            if (outputstack.func_190926_b()) {
                this.inventory.setStackInSlot(2, itemstack.func_77946_l());
            } else if (outputstack.func_77973_b() == itemstack.func_77973_b()) {
                outputstack.func_190917_f(itemstack.func_190916_E());
            }
            inputstack.func_190918_g(recipe.getInputCount());
            if (inputstack.func_190916_E() <= 0) {
                this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
            }
        }
    }

    private int getInventoryStackLimit() {
        return 64;
    }

    public void func_73660_a() {
        boolean burning = this.isBurning();
        boolean flag1 = false;
        if (this.isBurning()) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isValidStructure()) {
                return;
            }
            ItemStack inputstack = this.inventory.getStackInSlot(0);
            ItemStack fuelstack = this.inventory.getStackInSlot(1);
            if (this.isBurning() || !fuelstack.func_190926_b() && !inputstack.func_190926_b()) {
                if (!this.isBurning() && this.canSmelt()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = TileEntityTatara.getItemBurnTime(fuelstack);
                    if (this.isBurning()) {
                        flag1 = true;
                        if (!fuelstack.func_190926_b()) {
                            fuelstack.func_190918_g(1);
                            if (fuelstack.func_190916_E() == 0) {
                                this.inventory.setStackInSlot(1, fuelstack.func_77973_b().getContainerItem(fuelstack));
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.cookTime;
                    this.totalCookTime = this.getCookTime(inputstack);
                    if (this.cookTime >= this.totalCookTime) {
                        this.cookTime = 0;
                        this.totalCookTime = this.getCookTime(inputstack);
                        this.smeltItem();
                        flag1 = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
            }
            if (burning != this.isBurning()) {
                flag1 = true;
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }
}

