/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.tileentity;

import betterwithaddons.block.BlockWorldScale;
import betterwithaddons.handler.WorldScaleData;
import betterwithaddons.tileentity.TileEntityBase;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;

public class TileEntityWorldScaleActive
extends TileEntityBase
implements ITickable {
    ArrayList<ChunkPos> claimedChunks = new ArrayList();
    BlockPos oldPos;
    int updateTick = 0;
    final int UPDATE_TICKRATE = 50;
    final int MAX_RANGE = 5;

    public TileEntityWorldScaleActive() {
        this.setOldPos();
    }

    public void func_73660_a() {
        BlockPos pos = this.func_174877_v();
        if (!this.oldPos.equals((Object)pos)) {
            this.unclaimAllChunks();
            this.claimAllChunks();
            this.setOldPos();
        }
        if (this.updateTick++ > 50) {
            ChunkPos chunkpos = new ChunkPos(pos);
            this.claimChunk(chunkpos);
            for (int z = -5; z <= 5; ++z) {
                for (int x = -5; x <= 5; ++x) {
                    BlockPos newpos;
                    if (z == x && x == 0 || !this.field_145850_b.func_175667_e(newpos = pos.func_177982_a(x, 0, z))) continue;
                    IBlockState blockstate = this.field_145850_b.func_180495_p(newpos);
                    ChunkPos newchunk = new ChunkPos(chunkpos.field_77276_a + x, chunkpos.field_77275_b + z);
                    Block block = blockstate.func_177230_c();
                    if (block instanceof BlockWorldScale) {
                        boolean claimed = this.claimChunk(newchunk);
                        if (this.field_145850_b.field_72995_K) continue;
                        ((BlockWorldScale)block).setCracked(this.field_145850_b, newpos, blockstate, !claimed);
                        continue;
                    }
                    this.unclaimChunk(newchunk);
                }
            }
            this.updateTick = 0;
        }
    }

    public void setOldPos() {
        BlockPos pos;
        this.oldPos = pos = this.func_174877_v();
    }

    public boolean claimChunk(ChunkPos chunkpos) {
        if (this.claimedChunks.contains(chunkpos)) {
            return true;
        }
        WorldScaleData scaledata = WorldScaleData.getInstance(this.field_145850_b);
        if (scaledata != null && !scaledata.isClaimed(chunkpos)) {
            this.claimedChunks.add(chunkpos);
            scaledata.claimChunk(chunkpos, this.func_174877_v());
            return true;
        }
        return false;
    }

    public void unclaimChunk(ChunkPos chunkpos) {
        WorldScaleData scaledata = WorldScaleData.getInstance(this.field_145850_b);
        if (this.claimedChunks.contains(chunkpos)) {
            this.claimedChunks.remove(chunkpos);
            if (scaledata != null) {
                scaledata.unclaimChunk(chunkpos);
            }
        }
    }

    public void claimAllChunks() {
        BlockPos pos = this.func_174877_v();
        WorldScaleData scaledata = WorldScaleData.getInstance(this.field_145850_b);
        if (scaledata != null) {
            for (ChunkPos chunk : this.claimedChunks) {
                scaledata.claimChunk(chunk, pos);
            }
        }
    }

    public void unclaimAllChunks() {
        WorldScaleData scaledata = WorldScaleData.getInstance(this.field_145850_b);
        if (scaledata != null) {
            for (ChunkPos chunk : this.claimedChunks) {
                scaledata.unclaimChunk(chunk);
            }
        }
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound) {
        NBTTagList shardlist = new NBTTagList();
        for (ChunkPos chunkpos : this.claimedChunks) {
            NBTTagCompound shardcompound = new NBTTagCompound();
            shardcompound.func_74768_a("chunkX", chunkpos.field_77276_a);
            shardcompound.func_74768_a("chunkZ", chunkpos.field_77275_b);
            shardlist.func_74742_a((NBTBase)shardcompound);
        }
        compound.func_74782_a("claimedChunks", (NBTBase)shardlist);
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound) {
        NBTTagList shardlist = compound.func_150295_c("claimedChunks", 10);
        this.claimedChunks.clear();
        for (int i = 0; i < shardlist.func_74745_c(); ++i) {
            NBTTagCompound shardcompound = shardlist.func_150305_b(i);
            ChunkPos chunkpos = new ChunkPos(shardcompound.func_74762_e("chunkX"), shardcompound.func_74762_e("chunkZ"));
            this.claimedChunks.add(chunkpos);
        }
    }
}

