/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.util;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;

public class InventoryUtil {
    public static void addItemToPlayer(EntityPlayer playerIn, ItemStack retrieved) {
        if (playerIn.field_71071_by.func_70441_a(retrieved)) {
            playerIn.field_71071_by.func_70296_d();
            if (playerIn.field_71070_bA != null) {
                playerIn.field_71070_bA.func_75142_b();
            }
        } else {
            EntityItem ei = new EntityItem(playerIn.field_70170_p, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, retrieved);
            ei.field_70179_y = 0.0;
            ei.field_70181_x = 0.0;
            ei.field_70159_w = 0.0;
            ei.func_174867_a(0);
            playerIn.field_70170_p.func_72838_d((Entity)ei);
        }
    }

    public static void copyTags(ItemStack destStack, ItemStack sourceStack) {
        if (sourceStack.func_77942_o()) {
            destStack.func_77982_d(sourceStack.func_77978_p().func_74737_b());
        }
    }

    public static int getFirstOccupiedStackInRange(IItemHandler inv, int minSlot, int maxSlot) {
        for (int slot = minSlot; slot <= maxSlot; ++slot) {
            if (inv.getStackInSlot(slot).func_190926_b()) continue;
            return slot;
        }
        return -1;
    }

    public static void insert(IItemHandler inv, NonNullList<ItemStack> stacks, boolean simulate) {
        stacks.forEach(stack -> InventoryUtil.insert(inv, stack, 0, inv.getSlots(), simulate));
    }

    public static boolean insert(IItemHandler inv, ItemStack stack, boolean simulate) {
        return InventoryUtil.insert(inv, stack, 0, inv.getSlots(), simulate);
    }

    public static boolean insert(IItemHandler inv, ItemStack stack, int minSlot, int maxSlot, boolean simulate) {
        if (InventoryUtil.isFull(inv)) {
            return false;
        }
        boolean insert = false;
        for (int slot = minSlot; slot < maxSlot; ++slot) {
            if (!inv.insertItem(slot, stack, simulate).func_190926_b()) continue;
            insert = true;
            break;
        }
        return insert;
    }

    public static boolean isFull(IItemHandler inv) {
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (!stack.func_190926_b() && stack.func_190916_E() >= Math.min(inv.getSlotLimit(slot), stack.func_77976_d())) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(IItemHandler inv) {
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public static void shuffleInventory(IInventory inventory) {
        Random rgen = new Random();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            int randomPosition = rgen.nextInt(inventory.func_70302_i_());
            ItemStack temp = inventory.func_70301_a(i);
            inventory.func_70299_a(i, inventory.func_70301_a(randomPosition));
            inventory.func_70299_a(randomPosition, temp);
        }
    }

    public static int getInventorySlotContainItem(IInventory inventory, Item i) {
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            ItemStack itemInSlot = inventory.func_70301_a(slot);
            if (itemInSlot.func_190926_b() || itemInSlot.func_77973_b() != i) continue;
            return slot;
        }
        return -1;
    }

    public static void writeInventoryToCompound(NBTTagCompound compound, IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack is = inventory.func_70301_a(i);
            NBTTagCompound stackNBT = new NBTTagCompound();
            if (!is.func_190926_b()) {
                is.func_77955_b(stackNBT);
            } else {
                stackNBT.func_74757_a("empty", true);
            }
            compound.func_74782_a("slot" + i, (NBTBase)stackNBT);
        }
    }

    public static void readInventoryFromCompound(NBTTagCompound compound, IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            NBTTagCompound stackNBT = compound.func_74775_l("slot" + i);
            if (stackNBT == null) continue;
            if (stackNBT.func_74764_b("empty")) {
                inventory.func_70299_a(i, ItemStack.field_190927_a);
                continue;
            }
            inventory.func_70299_a(i, new ItemStack(stackNBT));
        }
    }

    public static int countItemInPlayer(Ingredient item, EntityPlayer player) {
        int count = 0;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack is = player.field_71071_by.func_70301_a(i);
            if (!item.apply(is)) continue;
            count += is.func_190916_E();
        }
        return count;
    }

    public static void consumeItemFromPlayer(Ingredient item, int consumed, EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack is = player.field_71071_by.func_70301_a(i);
            if (!item.apply(is)) continue;
            int removed = Math.min(is.func_190916_E(), consumed);
            if (removed <= 0) break;
            consumed -= removed;
            is.func_190918_g(removed);
            player.field_71071_by.func_70299_a(i, is);
        }
    }

    public static ItemStack getPlayerInventoryItem(Item item, EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack is = player.field_71071_by.func_70301_a(i);
            if (is.func_190926_b() || is.func_77973_b() != item) continue;
            return is;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isInventoryEmpty(IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_70301_a(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public static boolean listContains(ItemStack check, List<ItemStack> list) {
        if (list != null) {
            if (list.isEmpty()) {
                return false;
            }
            for (ItemStack item : list) {
                if (!ItemStack.func_179545_c((ItemStack)check, (ItemStack)item)) continue;
                return true;
            }
        }
        return false;
    }
}

