/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog;

import cd4017be.api.recipes.RecipeScriptContext;
import cd4017be.api.rs_ctr.sensor.SensorRegistry;
import cd4017be.indlog.Objects;
import cd4017be.indlog.item.ItemNameFilter;
import cd4017be.indlog.item.ItemPortableCrafter;
import cd4017be.indlog.item.ItemRemoteInv;
import cd4017be.indlog.modCompat.FilteredFluidSensor;
import cd4017be.indlog.modCompat.FilteredItemSensor;
import cd4017be.indlog.multiblock.FluidExtractor;
import cd4017be.indlog.multiblock.FluidInjector;
import cd4017be.indlog.multiblock.ItemExtractor;
import cd4017be.indlog.multiblock.ItemInjector;
import cd4017be.indlog.tileentity.AutoCrafter;
import cd4017be.indlog.tileentity.BlockPlacer;
import cd4017be.indlog.tileentity.Buffer;
import cd4017be.indlog.tileentity.DropedItemInterface;
import cd4017be.indlog.tileentity.EntityInterface;
import cd4017be.indlog.tileentity.FluidIO;
import cd4017be.indlog.tileentity.FluidPipe;
import cd4017be.indlog.tileentity.ItemPipe;
import cd4017be.indlog.tileentity.Pipe;
import cd4017be.indlog.tileentity.Tank;
import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.Gui.TileContainer;
import cd4017be.lib.TickRegistry;
import cd4017be.lib.script.Module;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;

public class CommonProxy {
    public void init() {
        TickRegistry.register();
        this.setConfig();
        BlockGuiHandler.registerContainer((Block)Objects.TANK, TileContainer.class);
        BlockGuiHandler.registerContainer((Block)Objects.BUFFER, TileContainer.class);
        BlockGuiHandler.registerContainer((Block)Objects.AUTO_CRAFT, TileContainer.class);
        BlockGuiHandler.registerContainer((Block)Objects.FLUID_INTAKE, TileContainer.class);
        BlockGuiHandler.registerContainer((Block)Objects.FLUID_OUTLET, TileContainer.class);
        BlockGuiHandler.registerContainer((Block)Objects.DROP_INTERFACE, DataContainer.class);
        if (Loader.isModLoaded((String)"rs_ctr")) {
            SensorRegistry.register(FilteredItemSensor::new, (ItemStack[])new ItemStack[]{new ItemStack((Item)Objects.item_filter), new ItemStack((Item)Objects.name_filter), new ItemStack((Item)Objects.property_filter)});
            SensorRegistry.register(FilteredFluidSensor::new, (ItemStack[])new ItemStack[]{new ItemStack((Item)Objects.fluid_filter)});
        }
    }

    private void setConfig() {
        RecipeScriptContext.ConfigConstants cfg = new RecipeScriptContext.ConfigConstants((Module)RecipeScriptContext.instance.modules.get("inductiveLogistics"));
        Pipe.SAVE_PERFORMANCE = (Boolean)cfg.get("pipe_fancy_content", Boolean.class, (Object)false) == false;
        FluidPipe.CAP = (int)cfg.getNumber("fluid_pipe_cap", 1000.0);
        FluidPipe.TICKS = Math.max((int)cfg.getNumber("fluid_pipe_tick", 1.0), 1);
        ItemPipe.TICKS = Math.max((int)cfg.getNumber("item_pipe_tick", 1.0), 1);
        byte by = (byte)cfg.getNumber("fluid_warp_tick", 4.0);
        FluidInjector.INTERVAL = by;
        FluidExtractor.INTERVAL = by;
        byte by2 = (byte)cfg.getNumber("item_warp_tick", 4.0);
        ItemInjector.INTERVAL = by2;
        ItemExtractor.INTERVAL = by2;
        cfg.getVect("tank_caps", Tank.CAP);
        cfg.getVect("buffer_slots", Buffer.SLOTS);
        cfg.getVect("buffer_stack", Buffer.STACKS);
        ItemPortableCrafter.INTERVAL = (int)cfg.getNumber("portable_craft_tick", 20.0);
        ItemRemoteInv.INTERVAL = (int)cfg.getNumber("remote_inv_tick", 20.0);
        ItemRemoteInv.MAX_SLOTS = Math.max(12, (int)cfg.getNumber("remote_max_slots", 96.0));
        AutoCrafter.INTERVAL = Math.max((int)cfg.getNumber("auto_craft_tick", 20.0), 1);
        FluidIO.CAP = (int)cfg.getNumber("fluid_io_cap", 8000.0);
        FluidIO.MAX_SIZE = Math.min((int)cfg.getNumber("fluid_io_range", 127.0), 127);
        FluidIO.SEARCH_MULT = Math.max((int)cfg.getNumber("fluid_io_path", 3.0), 1);
        FluidIO.SPEED = (int)cfg.getNumber("fluid_io_speed", 1.0);
        DropedItemInterface.INTERVAL = (int)cfg.getNumber("drop_interface_tick", 50.0);
        DropedItemInterface.MAX_RANGE = Math.max((int)cfg.getNumber("drop_interface_range", 15.0), 1);
        DropedItemInterface.INV_SIZE = (int)cfg.getNumber("drop_interface_slots", 5.0);
        EntityInterface.INTERVAL = (int)cfg.getNumber("entity_interface_tick", 10.0);
        BlockPlacer.RANGE = (int)cfg.getNumber("block_placer_range", (double)BlockPlacer.RANGE);
        ItemNameFilter.MAX_LENGTH = Math.max(1, (int)cfg.getNumber("name_filter_chars", (double)ItemNameFilter.MAX_LENGTH));
    }

    public void registerRenderers() {
    }
}

