/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog.filter;

import cd4017be.api.indlog.filter.FilterBase;
import cd4017be.indlog.Objects;
import cd4017be.lib.util.ItemFluidUtil;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class AmountFilter<Obj, Inv>
extends FilterBase<Obj, Inv> {
    public int amount;
    boolean inserted;

    AmountFilter() {
    }

    public boolean matches(Obj obj) {
        return true;
    }

    public boolean noEffect() {
        return this.amount <= 0;
    }

    public Item item() {
        return Objects.amount_filter;
    }

    public boolean transfer(Obj obj) {
        return this.inserted || (this.mode & 2) == 0;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74768_a("amount", this.amount);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.amount = nbt.func_74762_e("amount");
        super.deserializeNBT(nbt);
    }

    public static class ItemFilter
    extends AmountFilter<ItemStack, IItemHandler> {
        public int insertAmount(ItemStack obj, IItemHandler inv) {
            int n = obj.func_190916_E();
            if (this.amount < n) {
                n = this.amount;
            }
            if ((this.mode & 2) == 0) {
                return n;
            }
            if (n < this.amount) {
                obj = ItemHandlerHelper.copyStackWithSize((ItemStack)obj, (int)n);
            }
            this.inserted = true;
            int m = inv.getSlots();
            for (int i = 0; i < m; ++i) {
                if ((obj = inv.insertItem(i, obj, true)).func_190916_E() > 0) continue;
                return n;
            }
            this.inserted = false;
            return 0;
        }

        public ItemStack getExtract(ItemStack obj, IItemHandler inv) {
            int n = obj.func_190916_E();
            if (n <= 0) {
                ItemStack fallback = obj;
                int max = 0;
                int m = inv.getSlots();
                for (int i = 0; i < m; ++i) {
                    obj = inv.extractItem(i, this.amount, true);
                    n = obj.func_190916_E();
                    if (n == this.amount) {
                        return obj;
                    }
                    if (n <= max) continue;
                    fallback = obj;
                    max = n;
                }
                if ((this.mode & 2) == 0 && max > 0) {
                    fallback.func_190920_e(this.amount);
                    return fallback;
                }
            } else if (n >= this.amount || (this.mode & 2) == 0) {
                return ItemHandlerHelper.copyStackWithSize((ItemStack)obj, (int)this.amount);
            }
            return ItemStack.field_190927_a;
        }
    }

    public static class FluidFilter
    extends AmountFilter<FluidStack, IFluidHandler> {
        public int insertAmount(FluidStack obj, IFluidHandler inv) {
            if (obj == null) {
                return 0;
            }
            int n = obj.amount;
            if (this.amount < n) {
                n = this.amount;
            }
            if ((this.mode & 2) == 0) {
                return n;
            }
            if (n < this.amount) {
                obj = new FluidStack(obj, n);
            }
            if (inv.fill(obj, false) >= n) {
                this.inserted = true;
                return n;
            }
            this.inserted = false;
            return 0;
        }

        public FluidStack getExtract(FluidStack obj, IFluidHandler inv) {
            int n;
            int n2 = n = obj == null ? 0 : obj.amount;
            if (n <= 0) {
                FluidStack fallback = obj;
                int max = 0;
                for (IFluidTankProperties prop : ItemFluidUtil.listTanks((IFluidHandler)inv)) {
                    if (!prop.canDrain() || (obj = prop.getContents()) == null || (obj = inv.drain(obj, false)) == null) continue;
                    n = obj.amount;
                    if (n >= this.amount) {
                        return new FluidStack(obj, this.amount);
                    }
                    if (n <= max) continue;
                    fallback = obj;
                    max = n;
                }
                if ((this.mode & 2) == 0 && max > 0) {
                    return fallback;
                }
            } else if (n >= this.amount || (this.mode & 2) == 0) {
                return new FluidStack(obj, this.amount);
            }
            return null;
        }
    }
}

