/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog.filter;

import cd4017be.api.indlog.filter.FilterBase;
import cd4017be.indlog.Objects;
import cd4017be.lib.util.Utils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;

public class PipeFilterItem
extends FilterBase<ItemStack, IItemHandler> {
    public ItemStack[] list = new ItemStack[0];
    public int[] ores;

    public void generateOres() {
        this.ores = new int[this.list.length];
        for (int i = 0; i < this.list.length; ++i) {
            int[] l = OreDictionary.getOreIDs((ItemStack)this.list[i]);
            this.ores[i] = l.length > 0 ? l[0] : -1;
        }
    }

    public boolean noEffect() {
        return this.list.length == 0 && (this.mode & 1) == 0;
    }

    public int insertAmount(ItemStack obj, IItemHandler inv) {
        int m = obj.func_190916_E();
        if (m <= 0) {
            return 0;
        }
        int i = this.getMatch(obj);
        if ((this.mode & 0x20) != 0 && i >= 0) {
            int n = this.list[i].func_190916_E();
            Utils.ItemType filter = new Utils.ItemType((this.mode & 4) != 0, (this.mode & 8) != 0, (this.mode & 0x10) != 0, new ItemStack[]{this.list[i]});
            for (int s = 0; s < inv.getSlots(); ++s) {
                ItemStack item = inv.getStackInSlot(s);
                if (filter.matches(item)) {
                    n -= item.func_190916_E();
                }
                if (n > 0) continue;
                return 0;
            }
            return n;
        }
        return i >= 0 ^ (this.mode & 1) != 0 ? m : 0;
    }

    public ItemStack getExtract(ItemStack obj, IItemHandler inv) {
        int m = obj.func_190916_E();
        if (m > 0) {
            int i = this.getMatch(obj);
            if ((this.mode & 0x20) != 0 && i >= 0) {
                int n = -this.list[i].func_190916_E();
                for (int s = 0; s < inv.getSlots(); ++s) {
                    ItemStack item = inv.getStackInSlot(s);
                    if (item.func_190916_E() <= 0) continue;
                    if (this.matches(i, item)) {
                        n += item.func_190916_E();
                    }
                    if (n < m) continue;
                    n = m;
                    break;
                }
                return ItemHandlerHelper.copyStackWithSize((ItemStack)obj, (int)n);
            }
            if (i >= 0 ^ (this.mode & 1) != 0) {
                return obj.func_77946_l();
            }
            return ItemStack.field_190927_a;
        }
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack item = inv.getStackInSlot(i);
            if (item.func_190916_E() <= 0 || (item = this.getExtract(item, inv)).func_190916_E() <= 0) continue;
            return item;
        }
        return ItemStack.field_190927_a;
    }

    public boolean transfer(ItemStack stack) {
        if ((this.mode & 2) == 0) {
            return true;
        }
        if (stack.func_190916_E() <= 0) {
            return false;
        }
        return this.getMatch(stack) >= 0 ^ (this.mode & 1) == 0;
    }

    public int getMatch(ItemStack item) {
        if (item.func_190916_E() <= 0) {
            return -1;
        }
        for (int i = 0; i < this.list.length; ++i) {
            ItemStack type = this.list[i];
            if (item.func_77973_b() != type.func_77973_b() || (this.mode & 4) != 0 && item.func_77952_i() != type.func_77952_i() || (this.mode & 8) != 0 && !ItemStack.func_77970_a((ItemStack)item, (ItemStack)type)) continue;
            return i;
        }
        if (this.ores != null) {
            for (int o : OreDictionary.getOreIDs((ItemStack)item)) {
                for (int i = 0; i < this.ores.length; ++i) {
                    if (this.ores[i] != o) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    public boolean matches(int i, ItemStack item) {
        ItemStack type = this.list[i];
        if (!(item.func_77973_b() != type.func_77973_b() || (this.mode & 4) != 0 && item.func_77952_i() != type.func_77952_i() || (this.mode & 8) != 0 && !ItemStack.func_77970_a((ItemStack)item, (ItemStack)type))) {
            return true;
        }
        if (this.ores == null) {
            return false;
        }
        int o = this.ores[i];
        if (o < 0) {
            return false;
        }
        for (int j : OreDictionary.getOreIDs((ItemStack)item)) {
            if (j != o) continue;
            return true;
        }
        return false;
    }

    public boolean matches(ItemStack item) {
        return this.getMatch(item) >= 0 ^ (this.mode & 1) != 0;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        if (this.list.length > 0) {
            NBTTagList tlist = new NBTTagList();
            for (ItemStack item : this.list) {
                NBTTagCompound tag = new NBTTagCompound();
                item.func_77955_b(tag);
                tlist.func_74742_a((NBTBase)tag);
            }
            nbt.func_74782_a("Items", (NBTBase)tlist);
        }
        if (this.ores != null) {
            nbt.func_74783_a("ore", this.ores);
        }
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("Items")) {
            NBTTagList list = nbt.func_150295_c("Items", 10);
            this.list = new ItemStack[list.func_74745_c()];
            for (int i = 0; i < list.func_74745_c(); ++i) {
                this.list[i] = new ItemStack(list.func_150305_b(i));
            }
        }
        if ((this.mode & 0x10) != 0 && !nbt.func_150297_b("ore", 11) || (this.ores = nbt.func_74759_k("ore")).length != this.list.length) {
            this.generateOres();
        }
        super.deserializeNBT(nbt);
    }

    public Item item() {
        return Objects.item_filter;
    }
}

