/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog.item;

import cd4017be.api.indlog.filter.ItemFilterProvider;
import cd4017be.api.indlog.filter.PipeFilter;
import cd4017be.indlog.Objects;
import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.Gui.IGuiItem;
import cd4017be.lib.Gui.ItemGuiData;
import cd4017be.lib.capability.InventoryItem;
import cd4017be.lib.item.BaseItem;
import cd4017be.lib.util.IFilter;
import cd4017be.lib.util.ItemFluidUtil;
import java.io.IOException;
import java.util.function.ToIntFunction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public abstract class ItemFilteredSubInventory
extends BaseItem
implements InventoryItem.IItemInventory,
IGuiItem,
BlockGuiHandler.ClientItemPacketReceiver {
    public static final IFilter<ItemStack, IItemHandler> notMe = new IFilter<ItemStack, IItemHandler>(){

        public int insertAmount(ItemStack obj, IItemHandler inv) {
            int n = obj.func_190916_E();
            return n == 0 || obj.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) ? 0 : n;
        }

        public ItemStack getExtract(ItemStack obj, IItemHandler inv) {
            return obj.func_190916_E() == 0 || obj.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) ? ItemStack.field_190927_a : obj;
        }

        public boolean transfer(ItemStack obj) {
            return true;
        }
    };
    public static final ToIntFunction<ItemStack> FILTER_SLOT = item -> item.func_77973_b() instanceof ItemFilterProvider ? 1 : 0;

    public ItemFilteredSubInventory(String id) {
        super(id);
        this.func_77625_d(1);
    }

    public abstract ICapabilityProvider initCapabilities(ItemStack var1, NBTTagCompound var2);

    public ItemStack[] loadInventory(ItemStack inv, EntityPlayer player) {
        ItemStack[] items = new ItemStack[]{ItemFilteredSubInventory.loadFilter(inv.func_179543_a("fin")), ItemFilteredSubInventory.loadFilter(inv.func_179543_a("fout"))};
        return items;
    }

    public void saveInventory(ItemStack inv, EntityPlayer player, ItemStack[] items) {
        NBTTagCompound nbt;
        if (inv.func_77942_o()) {
            nbt = inv.func_77978_p();
        } else {
            nbt = new NBTTagCompound();
            inv.func_77982_d(nbt);
        }
        ItemStack fin = items[0];
        ItemStack fout = items[1];
        items[0] = ItemStack.field_190927_a;
        items[1] = ItemStack.field_190927_a;
        NBTTagCompound tag = ItemFilteredSubInventory.saveFilter(fin);
        if (tag != null) {
            nbt.func_74782_a("fin", (NBTBase)tag);
            items[0] = fin;
        } else {
            nbt.func_82580_o("fin");
        }
        tag = ItemFilteredSubInventory.saveFilter(fout);
        if (tag != null) {
            nbt.func_74782_a("fout", (NBTBase)tag);
            items[1] = fout;
        } else {
            nbt.func_82580_o("fout");
        }
    }

    public static ItemStack loadFilter(NBTTagCompound nbt) {
        if (nbt == null) {
            return ItemStack.field_190927_a;
        }
        Object i = Item.func_111206_d((String)nbt.func_74779_i("id"));
        if (i == null) {
            i = Objects.item_filter;
        }
        ItemStack stack = new ItemStack(i);
        stack.func_77982_d(nbt);
        return stack;
    }

    public static NBTTagCompound saveFilter(ItemStack item) {
        Item i = item.func_77973_b();
        if (i instanceof ItemFilterProvider) {
            ResourceLocation loc;
            NBTTagCompound nbt = item.func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound();
            }
            if ((loc = i.getRegistryName()) != null) {
                nbt.func_74778_a("id", loc.toString());
            }
            return nbt;
        }
        return null;
    }

    protected int tickTime() {
        return 20;
    }

    public void func_77663_a(ItemStack item, World world, Entity entity, int s, boolean b) {
        long t;
        if (world.field_72995_K) {
            return;
        }
        if (entity instanceof EntityPlayer && item.func_77942_o() && ((t = world.func_82737_E()) - (long)item.func_77978_p().func_74771_c("t") & 0xFFL) >= (long)this.tickTime()) {
            EntityPlayer player = (EntityPlayer)entity;
            InventoryPlayer inv = player.field_71071_by;
            PipeFilter in = item.func_77978_p().func_74764_b("fin") ? ItemFilterProvider.load((NBTTagCompound)item.func_77978_p().func_74775_l("fin")) : null;
            PipeFilter out = item.func_77978_p().func_74764_b("fout") ? ItemFilterProvider.load((NBTTagCompound)item.func_77978_p().func_74775_l("fout")) : null;
            this.updateItem(item, player, inv, s, (PipeFilter<ItemStack, IItemHandler>)in, (PipeFilter<ItemStack, IItemHandler>)out);
            item.func_77978_p().func_74774_a("t", (byte)t);
        }
    }

    protected void updateItem(ItemStack item, EntityPlayer player, InventoryPlayer inv, int s, PipeFilter<ItemStack, IItemHandler> in, PipeFilter<ItemStack, IItemHandler> out) {
        IItemHandler acc = (IItemHandler)item.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        PlayerMainInvWrapper pacc = new PlayerMainInvWrapper(inv);
        if (acc == null) {
            return;
        }
        if (in != null && in.active(false)) {
            ItemFluidUtil.transferItems((IItemHandler)pacc, (IItemHandler)acc, in, notMe);
        }
        if (out != null && out.active(false)) {
            ItemFluidUtil.transferItems((IItemHandler)acc, (IItemHandler)pacc, null, out);
        }
    }

    public void onPacketFromClient(PacketBuffer dis, EntityPlayer player, ItemStack item, int slot) throws IOException {
        byte cmd = dis.readByte();
        if (cmd >= 0 && cmd < 2) {
            String name;
            String string = name = cmd == 0 ? "fin" : "fout";
            if (item.func_77942_o() && item.func_77978_p().func_150297_b(name, 10)) {
                NBTTagCompound tag = item.func_77978_p().func_74775_l(name);
                byte m = tag.func_74771_c("mode");
                m = (byte)(m | 0x80);
                m = (byte)(m ^ 0x40);
                tag.func_74774_a("mode", m);
                ItemGuiData.updateInventory((EntityPlayer)player, (int)player.field_71071_by.field_70461_c);
            }
        } else {
            this.customPlayerCommand(item, player, cmd, dis);
        }
    }

    protected void customPlayerCommand(ItemStack item, EntityPlayer player, byte cmd, PacketBuffer dis) {
    }

    public static boolean isFilterOn(ItemStack item, boolean in) {
        if (item.func_77942_o() && item.func_77978_p().func_150297_b(in ? "fin" : "fout", 10)) {
            return (item.func_77978_p().func_74775_l(in ? "fin" : "fout").func_74771_c("mode") & 0xC0) == 192;
        }
        return false;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.func_77973_b() != newStack.func_77973_b();
    }
}

