/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog.item;

import cd4017be.indlog.render.gui.GuiPortableCrafting;
import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.Gui.IGuiItem;
import cd4017be.lib.Gui.ItemGuiData;
import cd4017be.lib.Gui.SlotHolo;
import cd4017be.lib.Gui.TileContainer;
import cd4017be.lib.capability.InventoryItem;
import cd4017be.lib.item.BaseItem;
import cd4017be.lib.util.ItemFluidUtil;
import java.io.IOException;
import java.util.Arrays;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemPortableCrafter
extends BaseItem
implements IGuiItem,
BlockGuiHandler.ClientItemPacketReceiver,
InventoryItem.IItemInventory {
    public static int INTERVAL;
    public static final String TIME = "t";
    public static final String ACTIVE = "active";
    public static final String AUTO = "auto";
    public static final String COUNT = "amount";
    public static final String INGRED = "ingreds";
    public static final String INGRED_IDX = "idx";
    public static final String RESULT = "result";
    public static final String DMG = "dmg";
    public static final String NBT = "nbt";
    public static final String RECIPE = "rcpId";
    public static final String JEI_DATA = "grid";

    public ItemPortableCrafter(String id) {
        super(id);
        this.func_77625_d(1);
    }

    public Container getContainer(ItemStack item, EntityPlayer player, World world, BlockPos pos, int slot) {
        return new TileContainer((DataContainer.IGuiData)new GuiData(), player);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(ItemStack item, EntityPlayer player, World world, BlockPos pos, int slot) {
        return new GuiPortableCrafting(new TileContainer((DataContainer.IGuiData)new GuiData(), player));
    }

    public void onPacketFromClient(PacketBuffer dis, EntityPlayer player, ItemStack item, int slot) throws IOException {
        if (item.func_77973_b() != this) {
            return;
        }
        NBTTagCompound nbt = item.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            item.func_77982_d(nbt);
        }
        switch (dis.readByte()) {
            case 0: {
                nbt.func_74757_a(ACTIVE, !nbt.func_74767_n(ACTIVE));
                break;
            }
            case 1: {
                nbt.func_74757_a(AUTO, !nbt.func_74767_n(AUTO));
                nbt.func_74757_a(ACTIVE, false);
                break;
            }
            case 2: {
                byte n = nbt.func_74771_c(COUNT);
                n = dis.readByte();
                if (n < 0) {
                    n = 0;
                }
                if (n > 64) {
                    n = 64;
                }
                nbt.func_74774_a(COUNT, n);
                break;
            }
            case 3: {
                int n = dis.readByte();
                Recipe recipe = new Recipe(nbt);
                recipe.craft(player.field_71071_by, n > 0 ? n : Integer.MAX_VALUE, false);
                if (player.field_71070_bA != null) {
                    player.field_71070_bA.func_75142_b();
                }
                nbt.func_74757_a(ACTIVE, false);
                break;
            }
            case 4: {
                try {
                    NBTTagCompound tag = dis.func_150793_b();
                    ItemStack[] inv = new ItemStack[10];
                    ItemFluidUtil.loadInventory((NBTTagList)tag.func_150295_c(JEI_DATA, 10), (ItemStack[])inv);
                    this.saveInventory(item, player, inv);
                    byte n = tag.func_74771_c(COUNT);
                    if (n < 0) {
                        n = 0;
                    }
                    if (n > 64) {
                        n = 64;
                    }
                    nbt.func_74774_a(COUNT, n);
                    nbt.func_74757_a(ACTIVE, false);
                    ItemGuiData.updateInventory((EntityPlayer)player, (int)player.field_71071_by.field_70461_c);
                }
                catch (IOException iOException) {}
                break;
            }
            case 5: {
                nbt.func_74757_a(DMG, !nbt.func_74767_n(DMG));
                this.saveInventory(item, player, this.loadInventory(item, player));
                ItemGuiData.updateInventory((EntityPlayer)player, (int)player.field_71071_by.field_70461_c);
                break;
            }
            case 6: {
                nbt.func_74757_a(NBT, !nbt.func_74767_n(NBT));
                this.saveInventory(item, player, this.loadInventory(item, player));
                ItemGuiData.updateInventory((EntityPlayer)player, (int)player.field_71071_by.field_70461_c);
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack item = player.func_184586_b(hand);
        BlockGuiHandler.openItemGui((EntityPlayer)player, (EnumHand)hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
    }

    public void func_77663_a(ItemStack item, World world, Entity entity, int s, boolean b) {
        if (entity instanceof EntityPlayer && !world.field_72995_K) {
            EntityPlayer player = (EntityPlayer)entity;
            NBTTagCompound nbt = item.func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound();
                item.func_77982_d(nbt);
            }
            long t = world.func_82737_E();
            if (nbt.func_74767_n(ACTIVE) && (t - (long)nbt.func_74771_c(TIME) & 0xFFL) >= (long)INTERVAL) {
                InventoryPlayer inv = player.field_71071_by;
                int n = nbt.func_74771_c(COUNT);
                boolean auto = nbt.func_74767_n(AUTO);
                Recipe recipe = new Recipe(nbt);
                n -= recipe.craft(inv, n, auto);
                if (!auto) {
                    nbt.func_74774_a(COUNT, (byte)n);
                }
                if (n <= 0 || recipe.result.func_190926_b()) {
                    nbt.func_74757_a(ACTIVE, false);
                }
                nbt.func_74774_a(TIME, (byte)t);
            }
        }
    }

    public ItemStack[] loadInventory(ItemStack inv, EntityPlayer player) {
        Object[] items = new ItemStack[10];
        Arrays.fill(items, ItemStack.field_190927_a);
        if (inv.func_77942_o()) {
            NBTTagCompound nbt = inv.func_77978_p();
            ItemStack[] ingreds = ItemFluidUtil.loadItems((NBTTagList)nbt.func_150295_c(INGRED, 10));
            int[] indices = nbt.func_74759_k(INGRED_IDX);
            int n = Math.min(indices.length, ingreds.length);
            for (int i = 0; i < n; ++i) {
                int k = indices[i] & 0x1FF;
                int j = 0;
                while (k != 0) {
                    if ((k & 1) != 0) {
                        items[j] = ItemHandlerHelper.copyStackWithSize((ItemStack)ingreds[i], (int)1);
                    }
                    k >>= 1;
                    ++j;
                }
            }
            if (nbt.func_74764_b(RESULT)) {
                items[9] = new ItemStack(nbt.func_74775_l(RESULT));
            }
        }
        return items;
    }

    public void saveInventory(ItemStack inv, EntityPlayer player, ItemStack[] items) {
        NBTTagCompound nbt = inv.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            inv.func_77982_d(nbt);
        }
        boolean useNBT = nbt.func_74767_n(NBT);
        boolean useDMG = nbt.func_74767_n(DMG);
        InventoryCrafting icr = ItemFluidUtil.craftingInventory((ItemStack[])items, (int)3);
        ItemStack[] ingreds = new ItemStack[9];
        int[] indices = new int[9];
        int n = 0;
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = items[i];
            if (stack.func_190926_b()) continue;
            for (int j = 0; j < n; ++j) {
                ItemStack ing = ingreds[j];
                if (!ItemPortableCrafter.itemEqual(ing, stack, useNBT, useDMG)) continue;
                int n2 = j;
                indices[n2] = indices[n2] | 1 << i;
                ingreds[j].func_190917_f(1);
                stack = null;
                break;
            }
            if (stack == null) continue;
            indices[n] = 1 << i;
            ingreds[n++] = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
        }
        nbt.func_74783_a(INGRED_IDX, Arrays.copyOf(indices, n));
        nbt.func_74782_a(INGRED, (NBTBase)ItemFluidUtil.saveItems((ItemStack[])Arrays.copyOf(ingreds, n)));
        String rcpIdx = "";
        for (IRecipe r : CraftingManager.field_193380_a) {
            if (!r.func_77569_a(icr, player.field_70170_p)) continue;
            rcpIdx = r.getRegistryName().toString();
            items[9] = r.func_77572_b(icr);
            nbt.func_74782_a(RESULT, (NBTBase)items[9].func_77955_b(new NBTTagCompound()));
            break;
        }
        if (rcpIdx.isEmpty()) {
            nbt.func_82580_o(RESULT);
            items[9] = ItemStack.field_190927_a;
        }
        nbt.func_74778_a(RECIPE, rcpIdx);
    }

    public static boolean itemEqual(ItemStack a, ItemStack b, boolean nbt, boolean dmg) {
        return a.func_77973_b() == b.func_77973_b() && (a.func_77952_i() == b.func_77952_i() || !dmg && a.func_77984_f()) && (!nbt || ItemStack.func_77970_a((ItemStack)a, (ItemStack)b));
    }

    public static boolean addToPlayer(ItemStack stack, InventoryPlayer inv) {
        if (inv.func_70441_a(stack)) {
            return false;
        }
        inv.field_70458_d.func_71019_a(stack, true);
        return true;
    }

    class GuiData
    extends ItemGuiData {
        public GuiData() {
            super((Item)ItemPortableCrafter.this);
        }

        public void initContainer(DataContainer container) {
            TileContainer cont = (TileContainer)container;
            this.inv = new InventoryItem(cont.player);
            for (int j = 0; j < 3; ++j) {
                for (int i = 0; i < 3; ++i) {
                    cont.addItemSlot((net.minecraft.inventory.Slot)new SlotHolo((IItemHandler)this.inv, i + 3 * j, 17 + i * 18, 16 + j * 18, false, false));
                }
            }
            cont.addItemSlot((net.minecraft.inventory.Slot)new SlotHolo((IItemHandler)this.inv, 9, 89, 34, true, true));
            cont.addPlayerInventory(8, 86, false, true);
        }
    }

    class Slot {
        final int i;
        Slot next;

        Slot(Slot parent, int i) {
            this.i = i;
            if (parent != null) {
                parent.next = this;
            }
        }
    }

    class Recipe {
        String rcpIdx;
        IRecipe recipe;
        ItemStack[] ingreds;
        int[] indices;
        ItemStack result;
        boolean useNBT;
        boolean useDMG;

        Recipe(NBTTagCompound nbt) {
            this.useDMG = nbt.func_74767_n(ItemPortableCrafter.DMG);
            this.useNBT = nbt.func_74767_n(ItemPortableCrafter.NBT);
            this.rcpIdx = nbt.func_74779_i(ItemPortableCrafter.RECIPE);
            this.indices = nbt.func_74759_k(ItemPortableCrafter.INGRED_IDX);
            this.ingreds = ItemFluidUtil.loadItems((NBTTagList)nbt.func_150295_c(ItemPortableCrafter.INGRED, 10));
            ItemStack itemStack = this.result = nbt.func_74764_b(ItemPortableCrafter.RESULT) ? new ItemStack(nbt.func_74775_l(ItemPortableCrafter.RESULT)) : ItemStack.field_190927_a;
            if (this.ingreds.length != this.indices.length) {
                this.indices = new int[0];
                this.ingreds = new ItemStack[0];
                this.rcpIdx = "";
            }
            if (!this.rcpIdx.isEmpty()) {
                this.recipe = (IRecipe)CraftingManager.field_193380_a.func_82594_a((Object)new ResourceLocation(this.rcpIdx));
            }
            if (this.recipe == null) {
                this.result = ItemStack.field_190927_a;
            }
        }

        int craft(InventoryPlayer inv, int n, boolean auto) {
            if (this.recipe == null || this.result.func_190926_b()) {
                return 0;
            }
            if (auto) {
                for (ItemStack stack : inv.field_70462_a) {
                    if (!ItemPortableCrafter.itemEqual(stack, this.result, this.useNBT, this.useDMG)) continue;
                    n -= stack.func_190916_E();
                }
            }
            if (n <= 0) {
                return 0;
            }
            n = (n - 1) / this.result.func_190916_E() + 1;
            Slot[] src = new Slot[this.ingreds.length];
            for (int j = 0; j < this.ingreds.length; ++j) {
                ItemStack ingred = this.ingreds[j];
                int o = ingred.func_190916_E();
                int m = 0;
                if (o <= 0) {
                    this.result = ItemStack.field_190927_a;
                    return 0;
                }
                Slot slot = null;
                ItemStack prev = null;
                for (int i = 0; i < inv.field_70462_a.size(); ++i) {
                    ItemStack stack = (ItemStack)inv.field_70462_a.get(i);
                    if (!ItemPortableCrafter.itemEqual(stack, ingred, this.useNBT, this.useDMG)) continue;
                    if (prev != null && n > m / o && !ItemHandlerHelper.canItemStacksStack(prev, (ItemStack)stack) && (n = m / o) == 0) {
                        n = 1;
                    }
                    m += stack.func_190916_E();
                    slot = new Slot(slot, i);
                    if (prev == null) {
                        src[j] = slot;
                    }
                    prev = stack;
                }
                if ((m /= o) >= n || (n = m) > 0) continue;
                return 0;
            }
            InventoryCrafting icr = new InventoryCrafting(ItemFluidUtil.CraftContDummy, 3, 3);
            for (int j = 0; j < this.ingreds.length; ++j) {
                Slot slot = src[j];
                int k = this.indices[j] & 0x1FF;
                int i = 0;
                while (k != 0) {
                    if ((k & 1) != 0) {
                        int m = n;
                        while (slot != null) {
                            ItemStack stack = (ItemStack)inv.field_70462_a.get(slot.i);
                            if (stack.func_190916_E() >= m) {
                                icr.func_70299_a(i, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)n));
                                stack.func_190917_f(-m);
                                break;
                            }
                            m -= stack.func_190916_E();
                            stack.func_190920_e(0);
                            slot = slot.next;
                        }
                    }
                    k >>= 1;
                    ++i;
                }
            }
            ForgeHooks.setCraftingPlayer((EntityPlayer)inv.field_70458_d);
            this.result = this.recipe.func_77572_b(icr);
            ForgeHooks.setCraftingPlayer(null);
            boolean invFull = false;
            if (this.result.func_190926_b()) {
                for (int i = 0; i < 9; ++i) {
                    invFull |= ItemPortableCrafter.addToPlayer(icr.func_70301_a(i), inv);
                }
            } else {
                if (n > 1) {
                    this.result.func_190920_e(this.result.func_190916_E() * n);
                }
                invFull |= ItemPortableCrafter.addToPlayer(this.result.func_77946_l(), inv);
                for (ItemStack stack : this.recipe.func_179532_b(icr)) {
                    int m = stack.func_190916_E();
                    if (m <= 0) continue;
                    if (n > 1) {
                        stack.func_190920_e(m * n);
                    }
                    invFull |= ItemPortableCrafter.addToPlayer(stack, inv);
                }
            }
            int n2 = n = auto ? 0 : this.result.func_190916_E();
            if (invFull) {
                this.result = ItemStack.field_190927_a;
            }
            return n;
        }
    }
}

