/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog.item;

import cd4017be.indlog.tileentity.Tank;
import cd4017be.indlog.util.FluidHandlerDirectNBT;
import cd4017be.lib.item.ItemVariantBlock;
import cd4017be.lib.render.FluidRenderer;
import cd4017be.lib.util.TooltipUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTank
extends ItemVariantBlock {
    public ItemTank(Block id) {
        super(id);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack item, @Nullable World player, List<String> list, ITooltipFlag b) {
        FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)item.func_77978_p());
        if (fluid == null) {
            list.add(TooltipUtil.format((String)"tile.indlog.tank.empty", (Object[])new Object[]{(double)ItemTank.cap(item) / 1000.0}));
        } else {
            list.add(TooltipUtil.format((String)"tile.indlog.tank.stor", (Object[])new Object[]{fluid.getLocalizedName(), (double)fluid.amount / 1000.0, (double)ItemTank.cap(item) / 1000.0}));
        }
        super.func_77624_a(item, player, list, b);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ItemTank item = this;
        for (int i = 0; i < Tank.CAP.length; ++i) {
            if (Tank.CAP[i] <= 0) continue;
            list.add((Object)new ItemStack((Item)item, 1, i));
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidHandlerDirectNBT(stack, ItemTank.cap(stack));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77942_o();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 1.0;
        }
        return 1.0 - (double)stack.func_77978_p().func_74762_e("Amount") / (double)ItemTank.cap(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public int getRGBDurabilityForDisplay(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        Fluid fluid = FluidRegistry.getFluid((String)stack.func_77978_p().func_74779_i("FluidName"));
        return fluid == null ? 0 : FluidRenderer.instance.fluidColor(fluid);
    }

    private static int cap(ItemStack stack) {
        int dmg = stack.func_77952_i();
        return dmg < 0 || dmg >= Tank.CAP.length ? 0 : Tank.CAP[dmg];
    }
}

