/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog.modCompat;

import cd4017be.api.indlog.filter.FluidFilterProvider;
import cd4017be.api.indlog.filter.PipeFilter;
import cd4017be.api.rs_ctr.com.BlockReference;
import cd4017be.api.rs_ctr.sensor.IBlockSensor;
import cd4017be.indlog.filter.DummyFilter;
import cd4017be.lib.util.ItemFluidUtil;
import cd4017be.lib.util.TooltipUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FilteredFluidSensor
implements IBlockSensor {
    final PipeFilter<FluidStack, IFluidHandler> filter;

    public FilteredFluidSensor(ItemStack stack) {
        this.filter = stack.func_77973_b() instanceof FluidFilterProvider ? ((FluidFilterProvider)stack.func_77973_b()).getFluidFilter(stack) : new DummyFilter(0);
    }

    public int readValue(BlockReference block) {
        IFluidHandler inv = (IFluidHandler)block.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        if (inv == null) {
            return 0;
        }
        int val = 0;
        for (IFluidTankProperties prop : ItemFluidUtil.listTanks((IFluidHandler)inv)) {
            FluidStack stack = prop.getContents();
            if (stack == null || !this.filter.matches((Object)stack)) continue;
            val += stack.amount;
        }
        return val;
    }

    public String getTooltipString() {
        return TooltipUtil.translate((String)"sensor.indlog.fluid_filter");
    }

    public ResourceLocation getModel() {
        return new ResourceLocation("rs_ctr:block/_sensor.fluid()");
    }
}

