/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog.multiblock;

import cd4017be.indlog.Objects;
import cd4017be.indlog.multiblock.FluidAccess;
import cd4017be.indlog.multiblock.FluidDestination;
import cd4017be.indlog.multiblock.FluidExtractor;
import cd4017be.indlog.multiblock.FluidInjector;
import cd4017be.indlog.multiblock.FluidSource;
import cd4017be.indlog.multiblock.ItemAccess;
import cd4017be.indlog.multiblock.ItemDestination;
import cd4017be.indlog.multiblock.ItemExtractor;
import cd4017be.indlog.multiblock.ItemInjector;
import cd4017be.indlog.multiblock.ItemSource;
import cd4017be.indlog.multiblock.WarpPipeNode;
import cd4017be.lib.util.ItemFluidUtil;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;

public abstract class ConComp {
    public final byte side;
    public final WarpPipeNode pipe;

    public ConComp(WarpPipeNode pipe, byte side) {
        this.side = side;
        this.pipe = pipe;
    }

    public void load(NBTTagCompound nbt) {
    }

    public void save(NBTTagCompound nbt) {
    }

    public static ConComp readFromNBT(WarpPipeNode pipe, NBTTagCompound nbt) {
        ConComp con;
        byte side = nbt.func_74771_c("s");
        byte type = nbt.func_74771_c("t");
        switch (type) {
            case 2: {
                con = new ItemDestination(pipe, side);
                break;
            }
            case 3: {
                con = new ItemExtractor(pipe, side);
                break;
            }
            case 4: {
                con = new FluidDestination(pipe, side);
                break;
            }
            case 5: {
                con = new FluidExtractor(pipe, side);
                break;
            }
            case 6: {
                con = new ItemInjector(pipe, side);
                break;
            }
            case 7: {
                con = new ItemSource(pipe, side);
                break;
            }
            case 8: {
                con = new ItemAccess(pipe, side);
                break;
            }
            case 9: {
                con = new FluidInjector(pipe, side);
                break;
            }
            case 10: {
                con = new FluidSource(pipe, side);
                break;
            }
            case 11: {
                con = new FluidAccess(pipe, side);
                break;
            }
            default: {
                pipe.con[side] = 1;
                return null;
            }
        }
        pipe.con[side] = type;
        con.load(nbt);
        return con;
    }

    public static NBTTagCompound writeToNBT(byte type, byte side) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("s", side);
        nbt.func_74774_a("t", type);
        return nbt;
    }

    public boolean onClicked(EntityPlayer player, EnumHand hand, ItemStack item) {
        if (item.func_190916_E() == 0 && player.func_70093_af()) {
            if (!player.func_184812_l_()) {
                ItemFluidUtil.dropStack((ItemStack)this.moduleItem(), (Entity)player);
            }
            this.pipe.remConnector(this.side);
            return true;
        }
        return false;
    }

    public static boolean createFromItem(ItemStack item, WarpPipeNode pipe, byte side) {
        ConComp con;
        if (item.func_190916_E() == 0 || pipe.con[side] >= 2) {
            return false;
        }
        Item type = item.func_77973_b();
        if (type == Objects.item_pipe && item.func_77952_i() == 3) {
            con = new ItemDestination(pipe, side);
            pipe.con[side] = 2;
        } else if (type == Objects.item_pipe && item.func_77952_i() == 2) {
            con = new ItemExtractor(pipe, side);
            pipe.con[side] = 3;
        } else if (type == Objects.fluid_pipe && item.func_77952_i() == 3) {
            con = new FluidDestination(pipe, side);
            pipe.con[side] = 4;
        } else if (type == Objects.fluid_pipe && item.func_77952_i() == 2) {
            con = new FluidExtractor(pipe, side);
            pipe.con[side] = 5;
        } else if (type == Objects.item_pipe && item.func_77952_i() == 1) {
            con = new ItemInjector(pipe, side);
            pipe.con[side] = 6;
        } else if (type == Objects.item_pipe && item.func_77952_i() == 4) {
            con = new ItemSource(pipe, side);
            pipe.con[side] = 7;
        } else if (type == Objects.item_pipe && item.func_77952_i() == 0) {
            con = new ItemAccess(pipe, side);
            pipe.con[side] = 8;
        } else if (type == Objects.fluid_pipe && item.func_77952_i() == 1) {
            con = new FluidInjector(pipe, side);
            pipe.con[side] = 9;
        } else if (type == Objects.fluid_pipe && item.func_77952_i() == 4) {
            con = new FluidSource(pipe, side);
            pipe.con[side] = 10;
        } else if (type == Objects.fluid_pipe && item.func_77952_i() == 0) {
            con = new FluidAccess(pipe, side);
            pipe.con[side] = 11;
        } else {
            return false;
        }
        pipe.setConnect(side, false);
        pipe.addConnector(con);
        pipe.isBlocked = (byte)(pipe.isBlocked | 1 << side);
        return true;
    }

    public void dropContent(List<ItemStack> list) {
        list.add(this.moduleItem());
    }

    protected abstract ItemStack moduleItem();
}

