/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog.multiblock;

import cd4017be.indlog.Objects;
import cd4017be.indlog.multiblock.FluidComp;
import cd4017be.indlog.multiblock.IActiveCon;
import cd4017be.indlog.multiblock.WarpPipeNetwork;
import cd4017be.indlog.multiblock.WarpPipeNode;
import cd4017be.lib.TickRegistry;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidExtractor
extends FluidComp
implements IActiveCon {
    public static int INTERVAL = 4;
    private int timer = Integer.MIN_VALUE;

    public FluidExtractor(WarpPipeNode pipe, byte side) {
        super(pipe, side);
    }

    @Override
    public void enable() {
        if (this.timer < 0 && !this.pipe.invalid()) {
            this.timer = 0;
            TickRegistry.instance.add((TickRegistry.ITickReceiver)this);
        }
    }

    @Override
    public void disable() {
        this.timer = Integer.MIN_VALUE;
    }

    public boolean tick() {
        FluidStack stack;
        if (++this.timer < INTERVAL) {
            return this.timer > 0;
        }
        if (this.pipe.invalid()) {
            this.disable();
            return false;
        }
        this.timer = 0;
        if (!this.isValid() || this.filter != null && !this.filter.active(this.pipe.redstone) || (this.pipe.isBlocked & 1 << this.side) != 0) {
            return true;
        }
        IFluidHandler acc = (IFluidHandler)this.link.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.field_82609_l[this.side ^ 1]);
        if (acc == null) {
            return true;
        }
        FluidStack fluidStack = stack = this.filter == null || this.filter.noEffect() ? acc.drain(Integer.MAX_VALUE, false) : (FluidStack)this.filter.getExtract(null, (Object)acc);
        if (stack == null) {
            return true;
        }
        int n = stack.amount;
        FluidStack result = ((WarpPipeNetwork)this.pipe.network).insertFluid(stack.copy(), this.filter == null || !this.filter.blocking() ? (byte)127 : this.filter.priority());
        if (result != null) {
            stack.amount -= result.amount;
        }
        if (n > 0) {
            acc.drain(stack, true);
        }
        return true;
    }

    @Override
    protected ItemStack moduleItem() {
        return new ItemStack((Item)Objects.fluid_pipe, 1, 2);
    }
}

