/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog.multiblock;

import cd4017be.indlog.Objects;
import cd4017be.indlog.multiblock.FluidComp;
import cd4017be.indlog.multiblock.WarpPipeNetwork;
import cd4017be.indlog.multiblock.WarpPipeNode;
import java.util.function.ToIntFunction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidSource
extends FluidComp
implements WarpPipeNetwork.IFluidSrc {
    public FluidSource(WarpPipeNode pipe, byte side) {
        super(pipe, side);
    }

    @Override
    public boolean blockFluid() {
        return this.filter != null && this.filter.blocking();
    }

    @Override
    public int extractFluid(FluidStack fluid, int max) {
        if (this.filter != null && !this.filter.active(this.pipe.redstone) || (this.pipe.isBlocked & 1 << this.side) != 0) {
            return 0;
        }
        IFluidHandler acc = (IFluidHandler)this.link.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.field_82609_l[this.side ^ 1]);
        if (acc == null) {
            return 0;
        }
        fluid = new FluidStack(fluid, max);
        if (this.filter != null && !this.filter.noEffect() && (fluid = (FluidStack)this.filter.getExtract((Object)fluid, (Object)acc)) == null) {
            return 0;
        }
        return (fluid = acc.drain(fluid, true)) == null ? 0 : fluid.amount;
    }

    @Override
    public FluidStack findFluid(ToIntFunction<FluidStack> acceptor) {
        if (this.filter != null && !this.filter.active(this.pipe.redstone) || (this.pipe.isBlocked & 1 << this.side) != 0) {
            return null;
        }
        IFluidHandler acc = (IFluidHandler)this.link.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.field_82609_l[this.side ^ 1]);
        if (acc == null) {
            return null;
        }
        IFluidTankProperties[] tankProps = acc.getTankProperties();
        if (tankProps == null) {
            return null;
        }
        for (IFluidTankProperties inf : tankProps) {
            int n;
            FluidStack stack;
            if (inf == null || (stack = inf.getContents()) == null || !inf.canDrainFluidType(stack) || this.filter != null && !this.filter.noEffect() && (stack = (FluidStack)this.filter.getExtract((Object)stack, (Object)acc)) == null || (n = acceptor.applyAsInt(stack)) <= 0) continue;
            return new FluidStack(stack, n);
        }
        return null;
    }

    @Override
    protected ItemStack moduleItem() {
        return new ItemStack((Item)Objects.fluid_pipe, 1, 4);
    }
}

