/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog.multiblock;

import cd4017be.indlog.multiblock.ConComp;
import cd4017be.indlog.multiblock.WarpPipeNode;
import cd4017be.lib.TickRegistry;
import cd4017be.lib.templates.NetworkNode;
import cd4017be.lib.templates.SharedNetwork;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.ToIntFunction;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class WarpPipeNetwork
extends SharedNetwork<WarpPipeNode, WarpPipeNetwork> {
    private static final byte SID = 1;
    private static final byte SIS = 2;
    private static final byte SFD = 4;
    private static final byte SFS = 8;
    public ArrayList<IItemDest> itemDest = new ArrayList();
    public ArrayList<IFluidDest> fluidDest = new ArrayList();
    public ArrayList<IItemSrc> itemSrc = new ArrayList();
    public ArrayList<IFluidSrc> fluidSrc = new ArrayList();
    private byte sort = 0;
    public static final Comparator<IPrioritySorted> destSort = new Comparator<IPrioritySorted>(){

        @Override
        public int compare(IPrioritySorted arg0, IPrioritySorted arg1) {
            return arg1.getPriority() - arg0.getPriority();
        }
    };
    public static final Comparator<IPrioritySorted> srcSort = new Comparator<IPrioritySorted>(){

        @Override
        public int compare(IPrioritySorted arg0, IPrioritySorted arg1) {
            return arg0.getPriority() - arg1.getPriority();
        }
    };

    public WarpPipeNetwork(WarpPipeNode core) {
        super((NetworkNode)core);
        for (ConComp c : core.cons) {
            if (c == null) continue;
            this.addConnector(c);
        }
    }

    protected WarpPipeNetwork(HashMap<Long, WarpPipeNode> comps) {
        super(comps);
    }

    public void reorder(ConComp con) {
        if (con instanceof IItemDest) {
            this.resort((byte)1);
        }
        if (con instanceof IFluidDest) {
            this.resort((byte)4);
        }
        if (con instanceof IItemSrc) {
            this.resort((byte)2);
        }
        if (con instanceof IFluidSrc) {
            this.resort((byte)8);
        }
    }

    protected void addConnector(ConComp con) {
        if (con instanceof IItemDest) {
            this.itemDest.add((IItemDest)((Object)con));
        }
        if (con instanceof IFluidDest) {
            this.fluidDest.add((IFluidDest)((Object)con));
        }
        if (con instanceof IItemSrc) {
            this.itemSrc.add((IItemSrc)((Object)con));
        }
        if (con instanceof IFluidSrc) {
            this.fluidSrc.add((IFluidSrc)((Object)con));
        }
        this.reorder(con);
    }

    protected void remConnector(ConComp con) {
        if (con instanceof IItemDest) {
            this.itemDest.remove(con);
        }
        if (con instanceof IFluidDest) {
            this.fluidDest.remove(con);
        }
        if (con instanceof IItemSrc) {
            this.itemSrc.remove(con);
        }
        if (con instanceof IFluidSrc) {
            this.fluidSrc.remove(con);
        }
    }

    public void onMerged(WarpPipeNetwork network) {
        super.onMerged((SharedNetwork)network);
        if (!network.itemDest.isEmpty()) {
            this.itemDest.addAll(network.itemDest);
            this.resort((byte)1);
        }
        if (!network.fluidDest.isEmpty()) {
            this.fluidDest.addAll(network.fluidDest);
            this.resort((byte)4);
        }
        if (!network.itemSrc.isEmpty()) {
            this.itemSrc.addAll(network.itemSrc);
            this.resort((byte)2);
        }
        if (!network.fluidSrc.isEmpty()) {
            this.fluidSrc.addAll(network.fluidSrc);
            this.resort((byte)8);
        }
    }

    public WarpPipeNetwork onSplit(HashMap<Long, WarpPipeNode> comps) {
        WarpPipeNetwork physics = new WarpPipeNetwork(comps);
        for (Map.Entry<Long, WarpPipeNode> e : comps.entrySet()) {
            for (ConComp c : e.getValue().cons) {
                if (c == null) continue;
                this.remConnector(c);
                physics.addConnector(c);
            }
        }
        return physics;
    }

    public void remove(WarpPipeNode comp) {
        comp.onRemoved();
        super.remove((NetworkNode)comp);
    }

    protected void resort(byte sort) {
        if (this.sort == 0 && !this.update) {
            TickRegistry.instance.updates.add(this);
        }
        this.sort = (byte)(this.sort | sort);
    }

    public void process() {
        super.process();
        if (this.sort != 0) {
            if ((this.sort & 1) != 0) {
                Collections.sort(this.itemDest, destSort);
            }
            if ((this.sort & 4) != 0) {
                Collections.sort(this.fluidDest, destSort);
            }
            if ((this.sort & 2) != 0) {
                Collections.sort(this.itemSrc, srcSort);
            }
            if ((this.sort & 8) != 0) {
                Collections.sort(this.fluidSrc, srcSort);
            }
            this.sort = 0;
        }
    }

    public ItemStack insertItem(ItemStack item, byte pr) {
        for (IItemDest dest : this.itemDest) {
            if (dest.getPriority() > pr || !dest.isValid()) continue;
            if ((item = dest.insertItem(item)) == null) {
                return null;
            }
            if (!dest.blockItem(item)) continue;
            return item;
        }
        return item;
    }

    public FluidStack insertFluid(FluidStack fluid, byte pr) {
        if (fluid == null) {
            return null;
        }
        for (IFluidDest dest : this.fluidDest) {
            if (dest.getPriority() > pr || !dest.isValid()) continue;
            if ((fluid = dest.insertFluid(fluid)) == null) {
                return null;
            }
            if (!dest.blockFluid(fluid)) continue;
            return fluid;
        }
        return fluid;
    }

    public int extractItem(ItemStack item, int am, byte pr) {
        int n = am;
        for (IItemSrc src : this.itemSrc) {
            if (src.getPriority() >= pr && src.isValid() && ((n -= src.extractItem(item, n)) <= 0 || src.blockItem())) break;
        }
        return am - n;
    }

    public ItemStack extractItem(ToIntFunction<ItemStack> acceptor, byte pr) {
        ItemStack stack = null;
        int n = Integer.MAX_VALUE;
        for (IItemSrc src : this.itemSrc) {
            if (src.getPriority() < pr || !src.isValid()) continue;
            if (stack != null) {
                n -= src.extractItem(stack, n);
            } else {
                stack = src.findItem(acceptor);
                if (stack != null) {
                    n = stack.func_190916_E();
                    n -= src.extractItem(stack, n);
                }
            }
            if (!src.blockItem() && n > 0) continue;
            break;
        }
        if (stack == null) {
            return null;
        }
        stack.func_190917_f(-n);
        return stack;
    }

    public int extractFluid(FluidStack fluid, int am, byte pr) {
        int n = am;
        for (IFluidSrc src : this.fluidSrc) {
            if (src.getPriority() >= pr && src.isValid() && ((n -= src.extractFluid(fluid, n)) <= 0 || src.blockFluid())) break;
        }
        return am - n;
    }

    public FluidStack extractFluid(ToIntFunction<FluidStack> acceptor, byte pr) {
        FluidStack stack = null;
        int n = Integer.MAX_VALUE;
        for (IFluidSrc src : this.fluidSrc) {
            if (src.getPriority() < pr || !src.isValid()) continue;
            if (stack != null) {
                n -= src.extractFluid(stack, n);
            } else {
                stack = src.findFluid(acceptor);
                if (stack != null) {
                    n = stack.amount;
                    n -= src.extractFluid(stack, n);
                }
            }
            if (!src.blockFluid() && n > 0) continue;
            break;
        }
        if (stack == null) {
            return null;
        }
        stack.amount -= n;
        return stack;
    }

    public static interface IFluidSrc
    extends IObjLink,
    IPrioritySorted {
        public int extractFluid(FluidStack var1, int var2);

        public FluidStack findFluid(ToIntFunction<FluidStack> var1);

        public boolean blockFluid();
    }

    public static interface IItemSrc
    extends IObjLink,
    IPrioritySorted {
        public int extractItem(ItemStack var1, int var2);

        public ItemStack findItem(ToIntFunction<ItemStack> var1);

        public boolean blockItem();
    }

    public static interface IFluidDest
    extends IObjLink,
    IPrioritySorted {
        public FluidStack insertFluid(FluidStack var1);

        public boolean blockFluid(FluidStack var1);
    }

    public static interface IItemDest
    extends IObjLink,
    IPrioritySorted {
        public ItemStack insertItem(ItemStack var1);

        public boolean blockItem(ItemStack var1);
    }

    public static interface IPrioritySorted {
        public byte getPriority();
    }

    public static interface IObjLink {
        public boolean isValid();

        public void updateLink();
    }
}

