/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog.tileentity;

import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.Gui.TileContainer;
import cd4017be.lib.block.AdvancedBlock;
import cd4017be.lib.capability.LinkedInventory;
import cd4017be.lib.tileentity.BaseTileEntity;
import cd4017be.lib.util.ItemFluidUtil;
import cd4017be.lib.util.SaferFakePlayer;
import cd4017be.lib.util.Utils;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.SlotItemHandler;

public class AutoCrafter
extends BaseTileEntity
implements ITickable,
AdvancedBlock.IRedstoneTile,
AdvancedBlock.ITilePlaceHarvest,
DataContainer.IGuiData,
BlockGuiHandler.ClientPacketReceiver {
    public static int INTERVAL = 10;
    private final InventoryCrafting icr = new InventoryCrafting(ItemFluidUtil.CraftContDummy, 3, 3);
    private GameProfile gp = new GameProfile(new UUID(0L, 0L), "dummyPlayer");
    private FakePlayer player;
    private IRecipe lastRecipe;
    private ItemStack output = ItemStack.field_190927_a;
    private final LinkedInventory inventory = new LinkedInventory(1, 64, i -> this.output, (o, i) -> {
        this.output = o;
    });
    private final ItemStack[] results = new ItemStack[7];
    private final byte[] inputs;
    public final byte[] grid;
    public byte rsMode;
    private byte rsOut;
    public int amount;
    private int lastAm;
    private boolean outEmpty;
    private byte time;

    public AutoCrafter() {
        Arrays.fill(this.results, ItemStack.field_190927_a);
        this.inputs = new byte[6];
        this.grid = new byte[10];
        Arrays.fill(this.grid, (byte)-1);
        this.lastAm = 1;
    }

    public AutoCrafter(IBlockState state) {
        super(state);
        Arrays.fill(this.results, ItemStack.field_190927_a);
        this.inputs = new byte[6];
        this.grid = new byte[10];
        Arrays.fill(this.grid, (byte)-1);
        this.lastAm = 1;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K || this.field_145850_b.func_82737_E() % (long)INTERVAL != (long)this.time) {
            return;
        }
        if (this.outEmpty && this.output.func_190916_E() < this.amount * this.lastAm && ((this.rsMode & 1) == 0 || this.hasRSInput())) {
            byte j;
            int i;
            byte nrs = 0;
            Ingred[] ingreds = new Ingred[6];
            for (i = 0; i < 6; ++i) {
                j = this.inputs[i];
                if (j <= 0) continue;
                Ingred ing = this.findIngred((IItemHandler)Utils.neighborCapability((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[i], (Capability)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY), this.amount * j);
                if (ing == null) {
                    nrs = (byte)(nrs | 1 << i);
                    continue;
                }
                ingreds[i] = ing;
            }
            if ((this.rsMode & 2) != 0 && nrs != this.rsOut) {
                this.updateRS(nrs);
            }
            if (nrs != 0) {
                return;
            }
            for (i = 0; i < 9; ++i) {
                j = this.grid[i];
                if (j < 0 || j >= 6) {
                    this.icr.func_70299_a(i, ItemStack.field_190927_a);
                    continue;
                }
                this.icr.func_70299_a(i, ItemHandlerHelper.copyStackWithSize((ItemStack)ingreds[j].stack, (int)1));
            }
            if (this.lastRecipe == null || !this.lastRecipe.func_77569_a(this.icr, this.field_145850_b)) {
                this.lastRecipe = null;
                for (IRecipe r : CraftingManager.field_193380_a) {
                    if (!r.func_77569_a(this.icr, this.field_145850_b)) continue;
                    this.lastRecipe = r;
                    break;
                }
                if (this.lastRecipe == null) {
                    return;
                }
            }
            if (this.player == null && this.field_145850_b instanceof WorldServer) {
                this.player = new SaferFakePlayer((WorldServer)this.field_145850_b, this.gp);
            }
            ForgeHooks.setCraftingPlayer((EntityPlayer)this.player);
            ItemStack stack = this.lastRecipe.func_77572_b(this.icr);
            ForgeHooks.setCraftingPlayer(null);
            this.lastAm = stack.func_190916_E();
            if (this.lastAm == 0) {
                return;
            }
            for (int i2 = 0; i2 < 6; ++i2) {
                if (ingreds[i2] == null) continue;
                int n = this.inputs[i2] * this.amount;
                if ((n -= ingreds[i2].extract(n)) <= 0) continue;
                this.results[i2] = ItemHandlerHelper.copyStackWithSize((ItemStack)ingreds[i2].stack, (int)(this.inputs[i2] * this.amount - n));
                --i2;
                while (i2 >= 0) {
                    this.results[i2] = ItemHandlerHelper.copyStackWithSize((ItemStack)ingreds[i2].stack, (int)(this.inputs[i2] * this.amount));
                    --i2;
                }
                this.func_70296_d();
                return;
            }
            if (this.amount > 1) {
                stack.func_190920_e(this.lastAm * this.amount);
            }
            this.results[6] = stack;
            this.outEmpty = false;
            NonNullList out = this.lastRecipe.func_179532_b(this.icr);
            for (int i3 = 0; i3 < out.size(); ++i3) {
                byte j2;
                stack = (ItemStack)out.get(i3);
                int n = stack.func_190916_E();
                if (n <= 0) continue;
                if (this.amount > 1) {
                    stack.func_190920_e(n * this.amount);
                }
                if ((j2 = this.grid[i3]) < 0 || j2 >= 6) {
                    ItemFluidUtil.dropStack((ItemStack)stack, (World)this.field_145850_b, (BlockPos)this.field_174879_c);
                    continue;
                }
                ItemStack item = this.results[j2];
                int m = item.func_190916_E();
                if (m <= 0) {
                    this.results[j2] = stack;
                    continue;
                }
                if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)item)) {
                    item.func_190920_e(m + n);
                    continue;
                }
                ItemFluidUtil.dropStack((ItemStack)stack, (World)this.field_145850_b, (BlockPos)this.field_174879_c);
            }
        } else if (this.rsOut != 0) {
            this.updateRS((byte)0);
        }
        if (!this.outEmpty) {
            this.output();
        }
    }

    private Ingred findIngred(IItemHandler acc, int am) {
        if (acc == null) {
            return null;
        }
        ArrayList<Ingred> found = new ArrayList<Ingred>();
        int s = acc.getSlots();
        for (int j = 0; j < s; ++j) {
            ItemStack item = acc.extractItem(j, am, true);
            int m = item.func_190916_E();
            if (m <= 0) continue;
            for (Ingred i : found) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)item, (ItemStack)i.stack)) continue;
                if (i.add(j, m) >= am) {
                    return i;
                }
                m = 0;
                break;
            }
            if (m == 0) continue;
            Ingred i = new Ingred(acc, item, j);
            if (m >= am) {
                return i;
            }
            found.add(i);
        }
        return null;
    }

    private void output() {
        byte s;
        ItemStack stack = this.results[6];
        if (stack.func_190916_E() <= 0 || (this.results[6] = this.inventory.insertItem(0, stack, false)).func_190916_E() <= 0) {
            this.outEmpty = true;
        }
        if ((s = this.grid[9]) < 0 || s >= 6) {
            for (int i = 0; i < 6; ++i) {
                stack = this.results[i];
                if (stack.func_190916_E() <= 0) continue;
                IItemHandler acc = (IItemHandler)Utils.neighborCapability((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[i], (Capability)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
                this.results[i] = stack = ItemHandlerHelper.insertItemStacked((IItemHandler)acc, (ItemStack)stack, (boolean)false);
                this.outEmpty &= stack.func_190916_E() <= 0;
            }
        } else {
            IItemHandler acc = (IItemHandler)Utils.neighborCapability((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[s], (Capability)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
            for (int i = 0; i < 6; ++i) {
                stack = this.results[i];
                if (stack.func_190916_E() <= 0) continue;
                this.results[i] = stack = ItemHandlerHelper.insertItemStacked((IItemHandler)acc, (ItemStack)stack, (boolean)false);
                this.outEmpty &= stack.func_190916_E() <= 0;
            }
        }
        this.func_70296_d();
    }

    private boolean hasRSInput() {
        for (EnumFacing dir : EnumFacing.values()) {
            if (this.inputs[dir.ordinal()] != 0 || this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(dir), dir) <= 0) continue;
            return true;
        }
        return false;
    }

    private void updateRS(byte nrs) {
        nrs = (byte)(nrs ^ this.rsOut);
        this.rsOut = (byte)(this.rsOut ^ nrs);
        for (EnumFacing dir : EnumFacing.values()) {
            if ((nrs & 1) != 0) {
                BlockPos bp = this.field_174879_c.func_177972_a(dir);
                IBlockState state = this.field_145850_b.func_180495_p(bp);
                state.func_189546_a(this.field_145850_b, bp, this.field_145854_h, this.field_174879_c);
                if (state.func_177230_c().shouldCheckWeakPower(state, (IBlockAccess)this.field_145850_b, bp, dir)) {
                    this.field_145850_b.func_175695_a(bp, this.field_145854_h, dir.func_176734_d());
                }
            }
            nrs = (byte)(nrs >> 1);
        }
    }

    private void updateGrid() {
        Arrays.fill(this.inputs, (byte)0);
        for (int i = 0; i < 9; ++i) {
            byte b = this.grid[i];
            if (b < 0 || b >= 6) continue;
            byte by = b;
            this.inputs[by] = (byte)(this.inputs[by] + 1);
        }
    }

    public int redstoneLevel(EnumFacing side, boolean strong) {
        return (this.rsOut >> side.ordinal() & 1) * 15;
    }

    public boolean connectRedstone(EnumFacing side) {
        return true;
    }

    public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> cap, EnumFacing facing) {
        return (T)(cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.inventory : null);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        this.gp = new GameProfile(nbt.func_186857_a("FPuuid"), nbt.func_74779_i("FPname"));
        this.output = new ItemStack(nbt.func_74775_l("result"));
        this.outEmpty = true;
        for (int i = 0; i < this.results.length; ++i) {
            this.results[i] = ItemFluidUtil.loadItemHighRes((NBTTagCompound)nbt.func_74775_l("out" + i));
            this.outEmpty &= this.results[i].func_190926_b();
        }
        this.amount = nbt.func_74771_c("am");
        this.rsMode = nbt.func_74771_c("mode");
        this.rsOut = nbt.func_74771_c("rs");
        byte[] ba = nbt.func_74770_j("grid");
        System.arraycopy(ba, 0, this.grid, 0, Math.min(this.grid.length, ba.length));
        this.updateGrid();
        this.lastAm = nbt.func_74771_c("lam");
        if (this.lastAm < 1) {
            this.lastAm = 1;
        }
        this.lastRecipe = null;
        super.func_145839_a(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_186854_a("FPuuid", this.gp.getId());
        nbt.func_74778_a("FPname", this.gp.getName());
        if (!this.output.func_190926_b()) {
            nbt.func_74782_a("result", (NBTBase)this.output.func_77955_b(new NBTTagCompound()));
        }
        for (int i = 0; i < this.results.length; ++i) {
            if (this.results[i].func_190926_b()) continue;
            nbt.func_74782_a("out" + i, (NBTBase)ItemFluidUtil.saveItemHighRes((ItemStack)this.results[i]));
        }
        nbt.func_74774_a("am", (byte)this.amount);
        nbt.func_74774_a("mode", this.rsMode);
        nbt.func_74774_a("rs", this.rsOut);
        nbt.func_74773_a("grid", this.grid);
        nbt.func_74774_a("lam", (byte)this.lastAm);
        return super.func_189515_b(nbt);
    }

    public void func_174878_a(BlockPos posIn) {
        super.func_174878_a(posIn);
        this.time = (posIn.func_177958_n() + posIn.func_177956_o() + posIn.func_177952_p() & 1) == 0 ? (byte)0 : (byte)Math.min(127, INTERVAL / 2);
    }

    public void onPacketFromClient(PacketBuffer data, EntityPlayer sender) throws IOException {
        int cmd = data.readByte() & 0xFF;
        if (cmd < 10) {
            this.grid[cmd] = data.readByte();
            this.updateGrid();
        } else if (cmd == 10) {
            this.amount = data.readByte() & 0xFF;
            if (this.amount > 64) {
                this.amount = 64;
            }
        } else if (cmd == 11) {
            this.rsMode = (byte)(this.rsMode ^ 1);
        } else if (cmd == 12) {
            this.rsMode = (byte)(this.rsMode ^ 2);
            if ((this.rsMode & 2) == 0) {
                this.updateRS((byte)0);
            }
        }
        this.func_70296_d();
    }

    public void initContainer(DataContainer container) {
        TileContainer cont = (TileContainer)container;
        cont.addItemSlot((Slot)new SlotItemHandler((IItemHandler)this.inventory, 0, 107, 34));
        cont.addPlayerInventory(8, 86);
    }

    public int[] getSyncVariables() {
        int pgrid = 0;
        for (int i = 0; i < this.grid.length; ++i) {
            pgrid |= (this.grid[i] & 7) << i * 3;
        }
        return new int[]{this.amount, this.rsMode, pgrid};
    }

    public void setSyncVariable(int i, int v) {
        switch (i) {
            case 0: {
                this.amount = v;
                break;
            }
            case 1: {
                this.rsMode = (byte)v;
                break;
            }
            case 2: {
                for (int j = 0; j < this.grid.length; ++j) {
                    int k = v >> j * 3 & 7;
                    this.grid[j] = (byte)(k >= 6 ? -1 : k);
                }
                break;
            }
        }
    }

    public boolean detectAndSendChanges(DataContainer container, PacketBuffer dos) {
        return false;
    }

    public void updateClientChanges(DataContainer container, PacketBuffer dis) {
    }

    public void onPlaced(EntityLivingBase entity, ItemStack item) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            this.gp = player.func_146103_bH();
        }
    }

    public List<ItemStack> dropItem(IBlockState state, int fortune) {
        List list = this.makeDefaultDrops(null);
        if (!this.output.func_190926_b()) {
            list.add(this.output);
        }
        for (ItemStack stack : this.results) {
            if (stack.func_190926_b()) continue;
            list.add(stack);
        }
        return list;
    }

    class Ingred {
        final IItemHandler acc;
        final ItemStack stack;
        final int[] idx;
        int l;

        Ingred(IItemHandler acc, ItemStack stack, int i) {
            this.acc = acc;
            this.stack = stack.func_77946_l();
            this.idx = new int[acc.getSlots() - i];
            this.idx[0] = i;
            this.l = 1;
        }

        int add(int i, int n) {
            this.idx[this.l++] = i;
            this.stack.func_190920_e(n += this.stack.func_190916_E());
            return n;
        }

        int extract(int n) {
            int m = 0;
            for (int i = 0; i < this.l && m < n; m += this.acc.extractItem(this.idx[i], n - m, false).func_190916_E(), ++i) {
            }
            return m;
        }
    }
}

