/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog.tileentity;

import cd4017be.api.indlog.filter.PipeFilter;
import cd4017be.lib.TickRegistry;
import cd4017be.lib.block.AdvancedBlock;
import cd4017be.lib.block.MultipartBlock;
import cd4017be.lib.property.PropertyByte;
import cd4017be.lib.templates.Cover;
import cd4017be.lib.tileentity.BaseTileEntity;
import cd4017be.lib.util.TileAccess;
import cd4017be.lib.util.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.capabilities.Capability;

public abstract class Pipe<T extends Pipe<T, O, I>, O, I>
extends BaseTileEntity
implements AdvancedBlock.INeighborAwareTile,
AdvancedBlock.IInteractiveTile,
MultipartBlock.IModularTile,
ITickable,
AdvancedBlock.ITilePlaceHarvest,
TickRegistry.IUpdatable {
    public static boolean SAVE_PERFORMANCE;
    public O content;
    public O last;
    protected T target;
    protected PipeFilter<O, I> filter;
    protected ArrayList<TileAccess> invs = null;
    protected byte type;
    protected byte dest;
    protected byte orDst;
    protected int redstone;
    protected short flow;
    private byte time;
    protected boolean updateCon = true;
    protected Cover cover = new Cover();
    private boolean onChunkBorder;
    private boolean justLoaded;

    public Pipe() {
    }

    public Pipe(IBlockState state) {
        super(state);
        this.type = (byte)this.field_145854_h.func_176201_c(state);
    }

    public void func_73660_a() {
        block22: {
            block21: {
                if (this.field_145850_b.field_72995_K) {
                    return;
                }
                if (this.field_145850_b.func_82737_E() % (long)this.resetTimer() != (long)this.time) break block21;
                if (this.updateCon) {
                    this.updateConnections();
                }
                switch (this.type) {
                    case 1: {
                        if ((this.flow & 0x8000) != 0) break;
                        if (this.content != null && (this.filter == null || this.filter.active(this.redstone > 0))) {
                            for (TileAccess inv : this.invs) {
                                Object acc;
                                if (inv.te.func_145837_r() || (acc = inv.te.getCapability(this.capability(), inv.side)) == null) {
                                    this.updateCon = true;
                                    continue;
                                }
                                if (!this.transferOut(acc)) continue;
                                break;
                            }
                        }
                    }
                    case 3: {
                        if ((this.flow & 0x3000) == 12288 && this.content != null && this.target != null && ((Pipe)((Object)this.target)).content == null && (this.filter == null || this.filter.transfer(this.content))) {
                            if (((Pipe)((Object)this.target)).unloaded) {
                                this.target = null;
                                break;
                            }
                            ((Pipe)((Object)this.target)).content = this.content;
                            this.content = null;
                            this.func_70296_d();
                            if (this.onChunkBorder) {
                                this.target.func_70296_d();
                                break;
                            }
                        }
                        break block22;
                    }
                    case 2: {
                        if ((this.flow & 0x8000) == 0 && (this.filter == null || this.filter.active(this.redstone > 0) && (this.content == null || !this.filter.blocking()))) {
                            for (TileAccess inv : this.invs) {
                                Object acc;
                                if (inv.te.func_145837_r() || (acc = inv.te.getCapability(this.capability(), inv.side)) == null) {
                                    this.updateCon = true;
                                    continue;
                                }
                                if (!this.transferIn(acc)) continue;
                                break;
                            }
                        }
                    }
                    default: {
                        if ((this.flow & 0x3000) == 12288 && this.content != null && this.target != null && ((Pipe)((Object)this.target)).content == null) {
                            if (((Pipe)((Object)this.target)).unloaded) {
                                this.target = null;
                                break;
                            }
                            ((Pipe)((Object)this.target)).content = this.content;
                            this.content = null;
                            this.func_70296_d();
                            if (this.onChunkBorder) {
                                this.target.func_70296_d();
                                break;
                            }
                        }
                        break block22;
                    }
                }
                break block22;
            }
            if (SAVE_PERFORMANCE) {
                return;
            }
        }
        if (!this.cover.opaque && this.content != this.last) {
            this.last = this.content;
            this.markUpdate();
        }
    }

    private boolean unloadedNeighbor() {
        int i = this.field_174879_c.func_177958_n() & 0xF;
        int j = this.field_174879_c.func_177952_p() & 0xF;
        return i == 0 && !this.field_145850_b.func_175667_e(this.field_174879_c.func_177976_e()) || i == 15 && !this.field_145850_b.func_175667_e(this.field_174879_c.func_177974_f()) || j == 0 && !this.field_145850_b.func_175667_e(this.field_174879_c.func_177978_c()) || j == 15 && !this.field_145850_b.func_175667_e(this.field_174879_c.func_177968_d());
    }

    protected void updateConnections() {
        TileEntity te;
        this.updateCon = false;
        if (this.invs != null) {
            this.invs.clear();
        } else if (this.type > 0 && this.type < 3) {
            this.invs = new ArrayList(5);
        }
        if (this.target != null && this.target.invalid()) {
            this.target = null;
            this.dest = (byte)-1;
        }
        if (this.justLoaded || this.onChunkBorder && this.unloadedNeighbor()) {
            for (EnumFacing s : EnumFacing.values()) {
                TileEntity te2;
                int io = this.getFlowBit(s.ordinal());
                if (io == 0 || io == 3 || (te2 = Utils.neighborTile((TileEntity)this, (EnumFacing)s)) == null) continue;
                if (this.pipeClass().isInstance(te2)) {
                    if (io != 1 || this.target != null) continue;
                    this.target = (Pipe)((Object)this.pipeClass().cast(te2));
                    continue;
                }
                if (!te2.hasCapability(this.capability(), s.func_176734_d()) || io != this.type) continue;
                this.invs.add(new TileAccess(te2, s.func_176734_d()));
            }
            return;
        }
        if (this.getFlowBit(this.dest) == 3) {
            this.orDst = (byte)-1;
            this.dest = (byte)-1;
            this.target = null;
        }
        this.redstone = this.field_145850_b.func_175687_A(this.field_174879_c);
        ArrayList<Pipe> updateList = new ArrayList<Pipe>();
        int newDest = this.target == null || ((Pipe)((Object)this.target)).getFlowBit(this.dest ^ 1) != 2 || (((Pipe)((Object)this.target)).getFlowBit(6) & 1) == 0 ? 2 : -1;
        int possDests = 0;
        int lHasIO = this.getFlowBit(6);
        int nHasIO = this.type > 2 ? this.type - 2 : 0;
        short lFlow = this.flow;
        if (this.dest != this.orDst) {
            this.setFlowBit(this.dest, 0);
            this.setFlowBit(this.orDst, 1);
            this.target = null;
        }
        for (byte i = 0; i < 6; ++i) {
            int lDirIO = this.getFlowBit(i);
            if (lDirIO == 3) continue;
            EnumFacing dir = EnumFacing.field_82609_l[i];
            te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir));
            if (te == null) {
                this.setFlowBit(i, 0);
                continue;
            }
            if (this.pipeClass().isInstance(te)) {
                Pipe pipe = (Pipe)((Object)this.pipeClass().cast(te));
                if (newDest < 0 && this.orDst == i) {
                    nHasIO |= 1;
                    updateList.add(pipe);
                    possDests |= 1 << i;
                    continue;
                }
                int pDirIO = pipe.getFlowBit(i ^ 1);
                if (pDirIO != 3) {
                    int pHasIO = pipe.getFlowBit(6);
                    int nDirIO = (~lHasIO | lDirIO) & ~pDirIO & pHasIO;
                    nDirIO = newDest <= 0 || newDest <= 1 && pDirIO != 2 && (pHasIO & 2) != 0 ? (nDirIO &= 2) : (nDirIO &= 3);
                    if (nDirIO == 3) {
                        nDirIO = 0;
                    }
                    if (nDirIO == 0) {
                        if (pDirIO != 1 && pHasIO == 1 || pDirIO == 2 && pHasIO == 3 && newDest == 2 && this.type == 1) {
                            nDirIO = 1;
                        } else if (pDirIO != 2 && pHasIO == 2) {
                            nDirIO = 2;
                        } else if (pDirIO == 2 && pHasIO == 3) {
                            possDests |= 1 << i;
                        }
                    }
                    if (nDirIO == 1) {
                        this.target = pipe;
                        if (this.orDst >= 0 && this.getFlowBit(this.orDst) == 1) {
                            this.setFlowBit(this.orDst, 0);
                        }
                        this.orDst = i;
                        newDest = pDirIO == 2 ? 0 : 1;
                    } else if (this.orDst == i) {
                        this.target = null;
                        this.orDst = (byte)-1;
                        this.updateCon = true;
                    }
                    this.setFlowBit(i, nDirIO);
                    nHasIO |= nDirIO;
                    updateList.add(pipe);
                    continue;
                }
                if (this.type > 0 && this.type < 3) {
                    this.setFlowBit(i, this.type);
                    nHasIO |= this.type;
                    this.invs.add(new TileAccess(te, dir.func_176734_d()));
                    continue;
                }
                this.setFlowBit(i, 3);
                continue;
            }
            if (this.type > 0 && this.type < 3 && te.hasCapability(this.capability(), dir.func_176734_d())) {
                this.setFlowBit(i, this.type);
                nHasIO |= this.type;
                this.invs.add(new TileAccess(te, dir.func_176734_d()));
                continue;
            }
            byte d = this.conDir(te, dir.func_176734_d());
            if (d == 1 && newDest >= 0) {
                if (this.orDst >= 0 && this.getFlowBit(this.orDst) == 1) {
                    this.setFlowBit(this.orDst, 0);
                }
                this.orDst = (byte)-1;
                this.target = null;
                newDest = -1;
            } else if (d == 3) {
                d = 0;
            }
            this.setFlowBit(i, d);
            nHasIO |= d;
        }
        this.setFlowBit(6, nHasIO);
        this.dest = this.orDst;
        if (this.dest >= 0) {
            int n;
            if (this.redstone > 0 && (n = Integer.bitCount(possDests &= ~(1 << this.orDst))) > 0) {
                n = (this.redstone - 1) % n;
                int i = 0;
                while (i < 6) {
                    if ((possDests & 1) != 0 && --n < 0) {
                        this.setFlowBit(this.orDst, 0);
                        this.dest = (byte)i;
                        this.setFlowBit(this.dest, 1);
                        this.target = null;
                        break;
                    }
                    ++i;
                    possDests >>= 1;
                }
            }
            if (this.target == null) {
                te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(EnumFacing.field_82609_l[this.dest]));
                if (this.pipeClass().isInstance(te)) {
                    this.target = (Pipe)((Object)this.pipeClass().cast(te));
                }
            }
        }
        this.flow = (short)(this.flow & 0xBFFF);
        if (this.flow != lFlow) {
            this.markUpdate();
            this.func_70296_d();
            for (Pipe pipe : updateList) {
                pipe.updateCon = true;
            }
        }
    }

    protected int getFlowBit(int b) {
        return this.flow >> b * 2 & 3;
    }

    protected void setFlowBit(int b, int v) {
        this.flow = (short)(this.flow & ~(3 << (b *= 2)) | (v & 3) << b);
    }

    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack item, EnumFacing dir, float X, float Y, float Z) {
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        if (this.cover.interact((BaseTileEntity)this, player, hand, item, dir, X, Y, Z)) {
            return true;
        }
        if (item.func_190916_E() > 0) {
            return false;
        }
        if (player.func_70093_af()) {
            int s;
            dir = Utils.hitSide((float)X, (float)Y, (float)Z);
            this.lockCon(s, this.getFlowBit(s = dir.func_176745_a()) == 3);
            return true;
        }
        if (this.filter == null) {
            this.flow = (short)(this.flow ^ 0x8000);
            this.markUpdate();
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public void onClicked(EntityPlayer player) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.cover.state == null) {
            int i;
            RayTraceResult hit = Utils.getHit((EntityPlayer)player, (IBlockState)this.getBlockState(), (BlockPos)this.field_174879_c);
            if (hit != null && (i = hit.subHit - 1) >= 0 && this.getFlowBit(i) != 3) {
                this.lockCon(i, false);
            }
        } else {
            this.cover.hit((BaseTileEntity)this, player);
        }
    }

    protected void lockCon(int s, boolean unlock) {
        int lock = unlock ? 0 : 3;
        this.setFlowBit(s, lock);
        if (lock != 0) {
            this.flow = (short)(this.flow | 0x4000);
        }
        this.updateCon = true;
        this.markUpdate();
        this.func_70296_d();
        TileEntity te = this.getTileOnSide(EnumFacing.field_82609_l[s]);
        if (this.pipeClass().isInstance(te)) {
            Pipe pipe = (Pipe)((Object)this.pipeClass().cast(te));
            if (unlock) {
                pipe.setFlowBit(s ^ 1, 0);
            } else if (pipe.type != 1 && pipe.type != 2) {
                pipe.setFlowBit(s ^ 1, 3);
                pipe.flow = (short)(pipe.flow | 0x4000);
            }
            pipe.updateCon = true;
            pipe.markUpdate();
            if (this.onChunkBorder) {
                pipe.func_70296_d();
            }
        }
    }

    public void neighborBlockChange(Block b, BlockPos src) {
        this.updateCon = true;
    }

    public void neighborTileChange(TileEntity te, EnumFacing side) {
        this.updateCon = true;
    }

    public void func_174878_a(BlockPos posIn) {
        super.func_174878_a(posIn);
        this.time = (posIn.func_177958_n() + posIn.func_177956_o() + posIn.func_177952_p() & 1) == 0 ? (byte)0 : (byte)Math.min(127, this.resetTimer() / 2);
        this.onChunkBorder = (posIn.func_177958_n() + 1 & 0xF) <= 1 || (posIn.func_177952_p() + 1 & 0xF) <= 1;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74774_a("type", this.type);
        nbt.func_74774_a("out", this.orDst);
        nbt.func_74774_a("outA", this.dest);
        nbt.func_74777_a("flow", this.flow);
        nbt.func_74768_a("rs", this.redstone);
        this.cover.writeNBT(nbt, "cover", false);
        return super.func_189515_b(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.type = nbt.func_74771_c("type");
        this.orDst = nbt.func_74771_c("out");
        this.dest = (byte)(nbt.func_150297_b("outA", 1) ? (int)nbt.func_74771_c("outA") : -1);
        this.flow = nbt.func_74765_d("flow");
        this.redstone = nbt.func_74762_e("rs");
        this.cover.readNBT(nbt, "cover", null);
        this.updateCon = true;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        IBlockState c = this.cover.state;
        this.cover.readNBT(nbt, "cv", (TileEntity)this);
        short nf = nbt.func_74765_d("flow");
        if (this.onDataPacket(nbt) || nf != this.flow || this.cover.state != c) {
            this.flow = nf;
            this.markUpdate();
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74777_a("flow", this.flow);
        this.cover.writeNBT(nbt, "cv", true);
        this.getUpdatePacket(nbt);
        return new SPacketUpdateTileEntity(this.func_174877_v(), -1, nbt);
    }

    public <M> M getModuleState(int m) {
        boolean isPipe;
        if (m == 6) {
            return (M)this.cover.module();
        }
        int b = this.getFlowBit(m);
        if (b == 3) {
            return (M)PropertyByte.cast((int)-1);
        }
        EnumFacing f = EnumFacing.field_82609_l[m];
        TileEntity p = Utils.neighborTile((TileEntity)this, (EnumFacing)f);
        boolean bl = isPipe = this.pipeClass().isInstance(p) && ((Pipe)p).getFlowBit(m ^ 1) != 3;
        if (b == 0) {
            if (!isPipe) {
                b = -1;
            }
        } else if ((this.flow & 0x8000) != 0) {
            if (!(b != this.type || b == 2 && isPipe)) {
                b += 4;
            }
        } else if (this.filter != null && (b == this.type || b == this.type - 2) && (!isPipe || b != 2 && this.filter.blocking())) {
            b += 2;
        }
        return (M)PropertyByte.cast((int)b);
    }

    public boolean isModulePresent(int m) {
        if (m == 6) {
            return this.cover.state != null;
        }
        int b = this.getFlowBit(m);
        if (b == 3) {
            return false;
        }
        if (b != 0) {
            return true;
        }
        EnumFacing f = EnumFacing.field_82609_l[m];
        TileEntity p = Utils.neighborTile((TileEntity)this, (EnumFacing)f);
        return this.pipeClass().isInstance(p);
    }

    public boolean isOpaque() {
        return this.cover.opaque;
    }

    public void onPlaced(EntityLivingBase entity, ItemStack item) {
    }

    public List<ItemStack> dropItem(IBlockState state, int fortune) {
        List list = this.makeDefaultDrops(null);
        if (this.cover.stack != null) {
            list.add(this.cover.stack);
        }
        return list;
    }

    public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
        return cap == this.capability();
    }

    public <C> C getCapability(Capability<C> cap, EnumFacing facing) {
        return cap == this.capability() ? (C)this.getInv(this.type != 0 && facing != null && this.getFlowBit(facing.ordinal()) != 3) : null;
    }

    protected abstract boolean transferOut(I var1);

    protected abstract boolean transferIn(I var1);

    protected abstract boolean onDataPacket(NBTTagCompound var1);

    protected abstract void getUpdatePacket(NBTTagCompound var1);

    protected abstract byte conDir(TileEntity var1, EnumFacing var2);

    protected abstract int resetTimer();

    protected abstract I getInv(boolean var1);

    protected abstract Class<T> pipeClass();

    protected abstract Capability<I> capability();

    public void process() {
        if (this.justLoaded) {
            this.justLoaded = false;
            if (!this.unloaded) {
                this.updateConnections();
            }
        }
    }

    protected void setupData() {
        if (!this.justLoaded) {
            this.justLoaded = true;
            TickRegistry.instance.updates.add(this);
        }
    }
}

