/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog.tileentity;

import cd4017be.api.indlog.pipe.IFluidPipeCon;
import cd4017be.api.indlog.pipe.IItemPipeCon;
import cd4017be.indlog.Objects;
import cd4017be.indlog.multiblock.ConComp;
import cd4017be.indlog.multiblock.WarpPipeNetwork;
import cd4017be.indlog.multiblock.WarpPipeNode;
import cd4017be.lib.block.AdvancedBlock;
import cd4017be.lib.block.MultipartBlock;
import cd4017be.lib.property.PropertyByte;
import cd4017be.lib.templates.Cover;
import cd4017be.lib.tileentity.BaseTileEntity;
import cd4017be.lib.tileentity.PassiveNetworkTile;
import cd4017be.lib.util.Utils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;

public class WarpPipe
extends PassiveNetworkTile<WarpPipeNode, WarpPipeNetwork, WarpPipe>
implements AdvancedBlock.ITilePlaceHarvest,
AdvancedBlock.IInteractiveTile,
MultipartBlock.IModularTile,
IItemPipeCon,
IFluidPipeCon {
    private Cover cover = new Cover();

    public WarpPipe() {
        this.comp = new WarpPipeNode(this);
    }

    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack item, EnumFacing dir, float X, float Y, float Z) {
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        if (this.cover.interact((BaseTileEntity)this, player, hand, item, dir, X, Y, Z)) {
            return true;
        }
        dir = Utils.hitSide((float)X, (float)Y, (float)Z);
        byte s = (byte)dir.func_176745_a();
        byte t = ((WarpPipeNode)this.comp).con[s];
        if (t >= 2) {
            ConComp con = ((WarpPipeNode)this.comp).cons[s];
            if (con != null && con.onClicked(player, hand, item)) {
                this.markUpdate();
                this.func_70296_d();
                return true;
            }
        } else if (player.func_70093_af() && item.func_190916_E() == 0) {
            ((WarpPipeNode)this.comp).setConnect(s, t != 0);
            this.markUpdate();
            this.func_70296_d();
            TileEntity te = Utils.neighborTile((TileEntity)this, (EnumFacing)dir);
            if (te instanceof WarpPipe) {
                WarpPipe wp = (WarpPipe)te;
                ((WarpPipeNode)wp.comp).setConnect((byte)(s ^ 1), t != 0);
                wp.markUpdate();
                wp.func_70296_d();
            }
            return true;
        }
        if (player.func_70093_af()) {
            return false;
        }
        if (t < 2 && ConComp.createFromItem(item, (WarpPipeNode)this.comp, s)) {
            if (!player.func_184812_l_()) {
                item.func_190917_f(-1);
                player.func_184611_a(hand, item);
            }
            this.markUpdate();
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public void onClicked(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K) {
            this.cover.hit((BaseTileEntity)this, player);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        ((WarpPipeNode)this.comp).writeToNBT(nbt);
        this.cover.writeNBT(nbt, "cover", false);
        return super.func_189515_b(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (((WarpPipeNode)this.comp).network != null) {
            ((WarpPipeNetwork)((WarpPipeNode)this.comp).network).remove((WarpPipeNode)this.comp);
        }
        this.comp = WarpPipeNode.readFromNBT(this, nbt);
        this.cover.readNBT(nbt, "cover", null);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        byte[] data = nbt.func_74770_j("con");
        if (data.length == 6) {
            System.arraycopy(data, 0, ((WarpPipeNode)this.comp).con, 0, 6);
        }
        ((WarpPipeNode)this.comp).hasFilters = nbt.func_74771_c("filt");
        ((WarpPipeNode)this.comp).isBlocked = nbt.func_74771_c("block");
        this.cover.readNBT(nbt, "cv", (TileEntity)this);
        this.markUpdate();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        byte[] data = new byte[((WarpPipeNode)this.comp).con.length];
        System.arraycopy(((WarpPipeNode)this.comp).con, 0, data, 0, data.length);
        nbt.func_74773_a("con", data);
        nbt.func_74774_a("filt", ((WarpPipeNode)this.comp).hasFilters);
        nbt.func_74774_a("block", ((WarpPipeNode)this.comp).isBlocked);
        this.cover.writeNBT(nbt, "cv", true);
        return new SPacketUpdateTileEntity(this.func_174877_v(), -1, nbt);
    }

    public <T> T getModuleState(int m) {
        if (m == 6) {
            return (T)this.cover.module();
        }
        byte t = ((WarpPipeNode)this.comp).con[m];
        if (t == 1) {
            return (T)PropertyByte.cast((int)-1);
        }
        if (t > 1) {
            return (T)PropertyByte.cast((int)(t - 1 + (((WarpPipeNode)this.comp).hasFilters >> m & 1) * 10 + (((WarpPipeNode)this.comp).isBlocked >> m & 1) * 20));
        }
        TileEntity te = Utils.neighborTile((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[m]);
        return (T)PropertyByte.cast((int)(te != null && te.hasCapability(Objects.WARP_PIPE_CAP, EnumFacing.field_82609_l[m ^ 1]) ? 0 : -1));
    }

    public boolean isModulePresent(int m) {
        if (m == 6) {
            return this.cover.state != null;
        }
        byte t = ((WarpPipeNode)this.comp).con[m];
        if (t == 1) {
            return false;
        }
        if (t > 1) {
            return true;
        }
        TileEntity te = Utils.neighborTile((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[m]);
        return te != null && te.hasCapability(Objects.WARP_PIPE_CAP, EnumFacing.field_82609_l[m ^ 1]);
    }

    public boolean isOpaque() {
        return this.cover.opaque;
    }

    public byte getFluidConnectDir(EnumFacing s) {
        byte t = ((WarpPipeNode)this.comp).con[s.ordinal()];
        return (byte)(t == 4 ? 2 : (t == 5 ? 1 : 0));
    }

    public byte getItemConnectDir(EnumFacing s) {
        byte t = ((WarpPipeNode)this.comp).con[s.ordinal()];
        return (byte)(t == 2 ? 2 : (t == 3 ? 1 : 0));
    }

    public void onPlaced(EntityLivingBase entity, ItemStack item) {
    }

    public List<ItemStack> dropItem(IBlockState state, int fortune) {
        List list = this.makeDefaultDrops(null);
        for (int i = 0; i < 6; ++i) {
            ConComp con = ((WarpPipeNode)this.comp).cons[i];
            if (con == null) continue;
            con.dropContent(list);
        }
        if (this.cover.stack != null) {
            list.add(this.cover.stack);
        }
        return list;
    }

    public void neighborBlockChange(Block b, BlockPos src) {
        ((WarpPipeNode)this.comp).redstone = this.field_145850_b.func_175640_z(this.field_174879_c);
        super.neighborBlockChange(b, src);
    }
}

