import crafttweaker.item.IIngredient;

import mods.zenstages.ZenStager;

import scripts.crafttweaker.utils;

import scripts.crafttweaker.stages.stageTutorial;
import scripts.crafttweaker.stages.stageZero;
import scripts.crafttweaker.stages.stageOne;
import scripts.crafttweaker.stages.stageTwo;
import scripts.crafttweaker.stages.stageThree;
import scripts.crafttweaker.stages.stageFour;
import scripts.crafttweaker.stages.stageFive;
import scripts.crafttweaker.stages.stageCreativeUnused;
import scripts.crafttweaker.stages.stageDisabled;

static stagedItems as IIngredient[][string] = {
	stageTutorial.stage: [
		<betterwithmods:cooked_mystery_meat:0>,
		<betterwithmods:mystery_meat:0>
	],

	stageZero.stage: [
		<betterwithmods:aesthetic:13>,
		<betterwithmods:aesthetic:6>,
		<betterwithmods:aesthetic:7>,
		<betterwithmods:beef_dinner:0>,
		<betterwithmods:beef_potatoes:0>,
		<betterwithmods:breeding_harness:0>,
		<betterwithmods:cooked_egg:0>,
		<betterwithmods:cooked_kebab:0>,
		<betterwithmods:cooked_omelet:0>,
		<betterwithmods:cooked_wolf_chop:0>,
		<betterwithmods:creeper_oyster:0>,
		<betterwithmods:dirt_pile:0>,
		<betterwithmods:dirt_slab:1>,
		<betterwithmods:dirt_slab:2>,
		<betterwithmods:dirt_slab:0>,
		<betterwithmods:gravel_pile:0>,
		<betterwithmods:ham_and_eggs:0>,
		<betterwithmods:hand_crank:0>,
		<betterwithmods:hemp:0>,
		<betterwithmods:leather_tanned_boots:*>,
		<betterwithmods:leather_tanned_chest:*>,
		<betterwithmods:leather_tanned_helmet:*>,
		<betterwithmods:leather_tanned_pants:0>,
		<betterwithmods:manual:0>,
		<betterwithmods:material:2>,
		<betterwithmods:material:3>,
		<betterwithmods:material:4>,
		<betterwithmods:material:9>,
		<betterwithmods:material:18>,
		<betterwithmods:material:26>,
		<betterwithmods:material:37>,
		<betterwithmods:material:44>,
		<betterwithmods:material:52>,
		<betterwithmods:material:53>,
		<betterwithmods:material:54>,
		<betterwithmods:material:0>,
		<betterwithmods:pork_dinner:0>,
		<betterwithmods:raw_egg:0>,
		<betterwithmods:raw_kebab:0>,
		<betterwithmods:raw_omelet:0>,
		<betterwithmods:red_sand_pile:0>,
		<betterwithmods:sand_pile:0>,
		<betterwithmods:shaft:0>,
		<betterwithmods:single_machine:0>,
		<betterwithmods:stake:0>,
		<betterwithmods:tasty_sandwich:0>,
		<betterwithmods:vine_trap:0>,
		<betterwithmods:wicker:0>,
		<betterwithmods:wolf_chop:0>
	],

	stageOne.stage: [
		// Custom MiniBlocks
		cornerHardenedclay,
		cornerSandstone,
		cornerWood,
		mouldingHardenedclay,
		mouldingSandstone,
		mouldingWood,
		utils.createAllMiniBlockIngredient(<betterwithmods:aesthetic:6>),
		utils.createAllMiniBlockIngredient(<minecraft:brick_block:0>),
		utils.createAllMiniBlockIngredient(<minecraft:hardened_clay:0>),
		utils.createAllMiniBlockIngredient(<minecraft:stone:0>),
		sidingHardenedclay,
		sidingSandstone,
		sidingWood,

		// Misc
		<betterwithmods:aesthetic:1>,
		<betterwithmods:aesthetic:4>,
		<betterwithmods:aesthetic:5>,
		<betterwithmods:aesthetic:9>,
		<betterwithmods:aesthetic:11>,
		<betterwithmods:aesthetic:0>,
		<betterwithmods:anchor:0>,
		<betterwithmods:axle_generator:1>,
		<betterwithmods:axle_generator:2>,
		<betterwithmods:axle_generator:0>,
		<betterwithmods:bamboo_chime:*>,
		<betterwithmods:bark:1>,
		<betterwithmods:bark:2>,
		<betterwithmods:bark:3>,
		<betterwithmods:bark:4>,
		<betterwithmods:bark:5>,
		<betterwithmods:bark:6>,
		<betterwithmods:bark:0>,
		<betterwithmods:bellows:0>,
		<betterwithmods:blood_leaves:0>,
		<betterwithmods:blood_log:0>,
		<betterwithmods:blood_sapling:0>,
		<betterwithmods:candle:1>,
		<betterwithmods:candle:2>,
		<betterwithmods:candle:3>,
		<betterwithmods:candle:4>,
		<betterwithmods:candle:5>,
		<betterwithmods:candle:6>,
		<betterwithmods:candle:7>,
		<betterwithmods:candle:8>,
		<betterwithmods:candle:9>,
		<betterwithmods:candle:10>,
		<betterwithmods:candle:11>,
		<betterwithmods:candle:12>,
		<betterwithmods:candle:13>,
		<betterwithmods:candle:14>,
		<betterwithmods:candle:15>,
		<betterwithmods:candle:0>,
		<betterwithmods:chicken_soup:0>,
		<betterwithmods:chocolate:0>,
		<betterwithmods:chowder:0>,
		<betterwithmods:cooking_pot:1>,
		<betterwithmods:cooking_pot:0>,
		<betterwithmods:donut:0>,
		<betterwithmods:grate:*>,
		<betterwithmods:hearty_stew:0>,
		<betterwithmods:kibble:0>,
		<betterwithmods:material:10>,
		<betterwithmods:material:11>,
		<betterwithmods:material:12>,
		<betterwithmods:material:13>,
		<betterwithmods:material:19>,
		<betterwithmods:material:21>,
		<betterwithmods:material:22>,
		<betterwithmods:material:24>,
		<betterwithmods:material:28>,
		<betterwithmods:material:41>,
		<betterwithmods:platform:0>,
		<betterwithmods:rope:0>,
		<betterwithmods:saw:0>,
		<betterwithmods:screw_pump:0>,
		<betterwithmods:single_machine:1>,
		<betterwithmods:single_machine:3>,
		<betterwithmods:slats:*>,
		<betterwithmods:stone_corner:2>,
		<betterwithmods:stone_corner:3>,
		<betterwithmods:stone_corner:4>,
		<betterwithmods:stone_corner:5>,
		<betterwithmods:stone_corner:0>,
		<betterwithmods:stone_moulding:2>,
		<betterwithmods:stone_moulding:3>,
		<betterwithmods:stone_moulding:4>,
		<betterwithmods:stone_moulding:5>,
		<betterwithmods:stone_moulding:0>,
		<betterwithmods:stone_siding:2>,
		<betterwithmods:stone_siding:3>,
		<betterwithmods:stone_siding:4>,
		<betterwithmods:stone_siding:5>,
		<betterwithmods:stone_siding:0>,
		<betterwithmods:unfired_pottery:1>,
		<betterwithmods:unfired_pottery:3>,
		<betterwithmods:unfired_pottery:0>,
		<betterwithmods:vase:*>,
		<betterwithmods:wood_bench:1>,
		<betterwithmods:wood_bench:2>,
		<betterwithmods:wood_bench:3>,
		<betterwithmods:wood_bench:4>,
		<betterwithmods:wood_bench:5>,
		<betterwithmods:wood_bench:0>,
		<betterwithmods:wood_corner:1>,
		<betterwithmods:wood_corner:2>,
		<betterwithmods:wood_corner:3>,
		<betterwithmods:wood_corner:4>,
		<betterwithmods:wood_corner:5>,
		<betterwithmods:wood_corner:0>,
		<betterwithmods:wood_moulding:1>,
		<betterwithmods:wood_moulding:2>,
		<betterwithmods:wood_moulding:3>,
		<betterwithmods:wood_moulding:4>,
		<betterwithmods:wood_moulding:5>,
		<betterwithmods:wood_moulding:0>,
		<betterwithmods:wood_siding:1>,
		<betterwithmods:wood_siding:2>,
		<betterwithmods:wood_siding:3>,
		<betterwithmods:wood_siding:4>,
		<betterwithmods:wood_siding:5>,
		<betterwithmods:wood_siding:0>,
		<betterwithmods:wooden_axle:0>,
		<betterwithmods:wooden_broken_gearbox:0>,
		<betterwithmods:wooden_gearbox:0>
	],

	stageTwo.stage: [
		// Custom MiniBlocks
		utils.createAllMiniBlockIngredient(<minecraft:stonebrick:1>),
		utils.createAllMiniBlockIngredient(<minecraft:stonebrick:2>),
		utils.createAllMiniBlockIngredient(<minecraft:stonebrick:3>),
		utils.createAllMiniBlockIngredient(<minecraft:stonebrick:0>),

		// Gold Stuff
		<betterwithmods:aesthetic:8>,
		<betterwithmods:material:40>,
		<betterwithmods:raw_pastry:1>,
		<betterwithmods:raw_pastry:2>,
		<betterwithmods:raw_pastry:4>,

		// Misc
		<betterwithmods:aesthetic:12>,
		<betterwithmods:apple_pie:0>,
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 0}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 1}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 2}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 3}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 4}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 5}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 6}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 7}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 8}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 9}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 10}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 11}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 12}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 13}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 14}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 15}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 16}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 17}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 18}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 19}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 20}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 21}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 22}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 23}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 24}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 25}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 26}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 27}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 28}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 29}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 30}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 31}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 32}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 33}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 34}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 35}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 36}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 37}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 38}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 39}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 40}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 41}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 42}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 43}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 44}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 48}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 49}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 50}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 51}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 61}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 62}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 70}),
		<betterwithmods:arcane_scroll:0>.withTag({enchant: 71}),
		<betterwithmods:bucket:0>,
		<betterwithmods:composite_bow:0>,
		<betterwithmods:dynamite:0>,
		<betterwithmods:ender_spectacles:0>,
		<betterwithmods:material:36>,
		<betterwithmods:metal_chime:*>,
		<betterwithmods:planter:1>,
		<betterwithmods:planter:2>,
		<betterwithmods:planter:3>,
		<betterwithmods:planter:4>,
		<betterwithmods:planter:5>,
		<betterwithmods:planter:6>,
		<betterwithmods:planter:7>,
		<betterwithmods:planter:8>,
		<betterwithmods:planter:9>,
		<betterwithmods:planter:0>,
		<betterwithmods:stone_corner:1>,
		<betterwithmods:stone_moulding:1>,
		<betterwithmods:stone_siding:1>,
		<betterwithmods:unfired_pottery:4>
	],

	stageThree.stage: [
		// Custom MiniBlocks
		utils.createAllMiniBlockIngredient(<betterwithmods:aesthetic:2>),
		utils.createAllMiniBlockIngredient(<betterwithmods:aesthetic:3>),
		utils.createAllMiniBlockIngredient(<minecraft:nether_brick:0>),
		utils.createAllMiniBlockIngredient(<minecraft:obsidian:0>),
		utils.createAllMiniBlockIngredient(<minecraft:quartz_block:1>),
		utils.createAllMiniBlockIngredient(<minecraft:quartz_block:2>),
		utils.createAllMiniBlockIngredient(<minecraft:quartz_block:0>),

		// Nether
		<betterwithmods:aesthetic:2>,
		<betterwithmods:material:35>,
		<betterwithmods:nether_clay:0>,
		<betterwithmods:nether_growth:0>,
		<betterwithmods:unfired_pottery:5>,

		// Misc
		<betterwithmods:aesthetic:3>,
		<betterwithmods:aesthetic:10>,
		<betterwithmods:bat_wing:0>,
		<betterwithmods:bellows:1>,
		<betterwithmods:block_dispenser:0>,
		<betterwithmods:booster:0>,
		<betterwithmods:broadhead_arrow:0>,
		<betterwithmods:buddy_block:0>,
		<betterwithmods:candle_holder:0>,
		<betterwithmods:companion_cube:0>,
		<betterwithmods:cooked_bat_wing:0>,
		<betterwithmods:cooked_scrambled_egg:0>,
		<betterwithmods:cooking_pot:2>,
		<betterwithmods:corner_iron:0>.withTag({texture: {Properties: {height: "0"}, Name: "betterwithmods:steel_block"}}),
		<betterwithmods:detector:0>,
		<betterwithmods:hibachi:0>,
		<betterwithmods:infernal_enchanter:0>,
		<betterwithmods:iron_wall:0>,
		<betterwithmods:lens:0>,
		<betterwithmods:light:0>,
		<betterwithmods:material:1>,
		<betterwithmods:material:8>,
		<betterwithmods:material:14>,
		<betterwithmods:material:15>,
		<betterwithmods:material:16>,
		<betterwithmods:material:17>,
		<betterwithmods:material:20>,
		<betterwithmods:material:23>,
		<betterwithmods:material:27>,
		<betterwithmods:material:29>,
		<betterwithmods:material:34>,
		<betterwithmods:material:38>,
		<betterwithmods:material:42>,
		<betterwithmods:material:43>,
		<betterwithmods:material:47>,
		<betterwithmods:material:48>,
		<betterwithmods:material:49>,
		<betterwithmods:material:50>,
		<betterwithmods:material:51>,
		<betterwithmods:mining_charge:0>,
		<betterwithmods:moulding_iron:0>.withTag({texture: {Properties: {height: "0"}, Name: "betterwithmods:steel_block"}}),
		<betterwithmods:raw_pastry:0>,
		<betterwithmods:raw_scrambled_egg:0>,
		<betterwithmods:siding_iron:0>.withTag({texture: {Properties: {height: "0"}, Name: "betterwithmods:steel_block"}}),
		<betterwithmods:single_machine:2>,
		<betterwithmods:stake:0>,
		<betterwithmods:steel_anvil:0>,
		<betterwithmods:steel_axe:*>,
		<betterwithmods:steel_axle:0>,
		<betterwithmods:steel_battleaxe:*>,
		<betterwithmods:steel_block:0>,
		<betterwithmods:steel_boots:*>,
		<betterwithmods:steel_broken_gearbox:0>,
		<betterwithmods:steel_chest:*>,
		<betterwithmods:steel_gearbox:0>,
		<betterwithmods:steel_hacksaw:*>,
		<betterwithmods:steel_helmet:*>,
		<betterwithmods:steel_hoe:*>,
		<betterwithmods:steel_mattock:0>,
		<betterwithmods:steel_pants:0>,
		<betterwithmods:steel_pickaxe:*>,
		<betterwithmods:steel_pressure_plate:0>,
		<betterwithmods:steel_saw:0>,
		<betterwithmods:steel_shovel:*>,
		<betterwithmods:steel_sword:*>,
		<betterwithmods:unfired_pottery:2>,
		<betterwithmods:urn:8>,
		<betterwithmods:urn:9>,
		<betterwithmods:urn:0>
	],

	stageFour.stage: [
		<betterwithmods:material:25>,
		<betterwithmods:material:39>,
	],

	stageFive.stage: [
		<betterwithmods:material:45>
	],

	stageCreativeUnused.stage: [
		<betterwithmods:creative_generator:0>
	]
};

static hiddenItems as IIngredient[] = [
	<betterwithmods:cobblestone:1>,
	<betterwithmods:cobblestone:2>,
	<betterwithmods:cobblestone:0>,
	<betterwithmods:fertile_farmland:0>,
	<betterwithmods:fertilizer:0>,
	<betterwithmods:material:30>,
	<betterwithmods:material:5>,
	utils.createAllMiniBlockIngredient(<betterwithmods:aesthetic:10>),
	utils.createAllMiniBlockIngredient(<betterwithmods:aesthetic:11>),
	utils.createAllMiniBlockIngredient(<betterwithmods:nether_clay:0>),
	utils.createAllMiniBlockIngredient(<minecraft:clay:0>)
];

static hiddenRemove as IIngredient[] = [
	<betterwithmods:material:31>,
	<betterwithmods:material:32>,
	<betterwithmods:material:33>,
	<betterwithmods:material:6>,
	<betterwithmods:material:7>,
	<betterwithmods:raw_pastry:3>,
	<betterwithmods:stump_remover:0>,
	<betterwithmods:wood_table:0>,
	<betterwithmods:wood_table:1>,
	<betterwithmods:wood_table:2>,
	<betterwithmods:wood_table:3>,
	<betterwithmods:wood_table:4>,
	<betterwithmods:wood_table:5>,
	<betterwithmods:wool_boots:*>,
	<betterwithmods:wool_chest:*>,
	<betterwithmods:wool_helmet:*>,
	<betterwithmods:wool_pants:*>
];

function init() {
	var modId as string = stagedItems.entrySet[0].value[0].items[0].definition.owner;

	var modStage as string = scripts.crafttweaker.staging.itemsAndRecipes.modId.containsMod(modId);
	var doOverride as bool = modStage != "";

	for stageName, items in stagedItems {
		if (doOverride && stageName != modStage) {
			ZenStager.addModItemOverrides(modId, items);
		}

		ZenStager.getStage(stageName).addIngredients(items);
	}
	recipeUtil.hideItems(hiddenItems as IIngredient[]);
	recipeUtil.hideItems(hiddenRemove as IIngredient[], true);
}
