import crafttweaker.item.IIngredient;

import mods.zenstages.ZenStager;

import scripts.crafttweaker.stages.stageTwo;
import scripts.crafttweaker.stages.stageFour;
import scripts.crafttweaker.stages.stageFive;
import scripts.crafttweaker.stages.stageDisabled;
import scripts.crafttweaker.stages.stageCreativeUnused;

static stagedItems as IIngredient[][string] = {
	stageTwo.stage: [
		<extraplanets:apple_iron:0>
	],

	stageFour.stage: [
		<extraplanets:oxygen_tank_light_full_black:*>,
		<extraplanets:oxygen_tank_light_full_blue:*>,
		<extraplanets:oxygen_tank_light_full_brown:*>,
		<extraplanets:oxygen_tank_light_full_cyan:*>,
		<extraplanets:oxygen_tank_light_full_gray:*>,
		<extraplanets:oxygen_tank_light_full_green:*>,
		<extraplanets:oxygen_tank_light_full_light_blue:*>,
		<extraplanets:oxygen_tank_light_full_light_gray:*>,
		<extraplanets:oxygen_tank_light_full_magenta:*>,
		<extraplanets:oxygen_tank_light_full_orange:*>,
		<extraplanets:oxygen_tank_light_full_pink:*>,
		<extraplanets:oxygen_tank_light_full_purple:*>,
		<extraplanets:oxygen_tank_light_full_red:*>,
		<extraplanets:oxygen_tank_light_full_white:*>,
		<extraplanets:oxygen_tank_light_full_yellow:*>,
		<extraplanets:tier1_armor_layer:0>,
		<extraplanets:tier1_pressure_layer:0>,
		<extraplanets:tier1_radiation_layer:0>,
		<extraplanets:tier1_space_suit_boots:*>,
		<extraplanets:tier1_space_suit_chest:*>,
		<extraplanets:tier1_space_suit_helmet:*>,
		<extraplanets:tier1_space_suit_legings:*>,
		<extraplanets:tier1_un_prepared_space_suit_boots:*>,
		<extraplanets:tier1_un_prepared_space_suit_chest:*>,
		<extraplanets:tier1_un_prepared_space_suit_helmet:*>,
		<extraplanets:tier1_un_prepared_space_suit_legings:*>,
		<extraplanets:tier11_items:6>
	],

	stageFive.stage: [
		<extraplanets:advanced_battery:0>,
		<extraplanets:advanced_fuel_loader:0>,
		<extraplanets:advanced_launch_pad_full:0>,
		<extraplanets:advanced_launch_pad:1>,
		<extraplanets:advanced_launch_pad:2>,
		<extraplanets:advanced_launch_pad:3>,
		<extraplanets:advanced_launch_pad:0>,
		<extraplanets:advanced_oxygen_compressor:4>,
		<extraplanets:advanced_oxygen_compressor:0>,
		<extraplanets:apple_diamond:1>,
		<extraplanets:apple_iron:1>,
		<extraplanets:ash_rock:0>,
		<extraplanets:basic_densifier:0>,
		<extraplanets:blue_diamond_axe:*>,
		<extraplanets:blue_diamond_boots:*>,
		<extraplanets:blue_diamond_chest:*>,
		<extraplanets:blue_diamond_helmet:*>,
		<extraplanets:blue_diamond_hoe:*>,
		<extraplanets:blue_diamond_legings:*>,
		<extraplanets:blue_diamond_pickaxe:*>,
		<extraplanets:blue_diamond_shovel:*>,
		<extraplanets:blue_diamond_sword:*>,
		<extraplanets:cake_blocks:1>,
		<extraplanets:cake_blocks:2>,
		<extraplanets:cake_blocks:3>,
		<extraplanets:cake_blocks:4>,
		<extraplanets:cake_blocks:5>,
		<extraplanets:cake_blocks:6>,
		<extraplanets:cake_blocks:7>,
		<extraplanets:cake_blocks:0>,
		<extraplanets:callisto_gravel:0>,
		<extraplanets:callisto:1>,
		<extraplanets:callisto:2>,
		<extraplanets:callisto:3>,
		<extraplanets:callisto:4>,
		<extraplanets:callisto:5>,
		<extraplanets:callisto:6>,
		<extraplanets:callisto:7>,
		<extraplanets:callisto:0>,
		<extraplanets:candy_blocks_horizontal:1>,
		<extraplanets:candy_blocks_horizontal:2>,
		<extraplanets:candy_blocks_horizontal:3>,
		<extraplanets:candy_blocks_horizontal:4>,
		<extraplanets:candy_blocks_horizontal:5>,
		<extraplanets:candy_blocks_horizontal:6>,
		<extraplanets:candy_blocks_horizontal:7>,
		<extraplanets:candy_blocks_horizontal:8>,
		<extraplanets:candy_blocks_horizontal:9>,
		<extraplanets:candy_blocks_horizontal:0>,
		<extraplanets:candy_blocks:1>,
		<extraplanets:candy_blocks:2>,
		<extraplanets:candy_blocks:3>,
		<extraplanets:candy_blocks:4>,
		<extraplanets:candy_blocks:5>,
		<extraplanets:candy_blocks:6>,
		<extraplanets:candy_blocks:7>,
		<extraplanets:candy_blocks:8>,
		<extraplanets:candy_blocks:9>,
		<extraplanets:candy_blocks:0>,
		<extraplanets:caramel_bar:0>,
		<extraplanets:ceres_gravel:0>,
		<extraplanets:ceres_stairs_stone_bricks:0>,
		<extraplanets:ceres_stairs_stone:0>,
		<extraplanets:ceres_stairs_sub_surface:0>,
		<extraplanets:ceres_stairs_surface:0>,
		<extraplanets:ceres:1>,
		<extraplanets:ceres:2>,
		<extraplanets:ceres:3>,
		<extraplanets:ceres:4>,
		<extraplanets:ceres:5>,
		<extraplanets:ceres:6>,
		<extraplanets:ceres:7>,
		<extraplanets:ceres:8>,
		<extraplanets:ceres:0>,
		<extraplanets:chocolate_bar:0>,
		<extraplanets:cloth:0>,
		<extraplanets:coal_grit:0>,
		<extraplanets:compressed_mercury:0>,
		<extraplanets:decorative_blocks:1>,
		<extraplanets:decorative_blocks:2>,
		<extraplanets:decorative_blocks:3>,
		<extraplanets:decorative_blocks:4>,
		<extraplanets:decorative_blocks:5>,
		<extraplanets:decorative_blocks:6>,
		<extraplanets:decorative_blocks:7>,
		<extraplanets:decorative_blocks:8>,
		<extraplanets:decorative_blocks:9>,
		<extraplanets:decorative_blocks:10>,
		<extraplanets:decorative_blocks:11>,
		<extraplanets:decorative_blocks:12>,
		<extraplanets:decorative_blocks:13>,
		<extraplanets:decorative_blocks:14>,
		<extraplanets:decorative_blocks:15>,
		<extraplanets:decorative_blocks:0>,
		<extraplanets:decorative_blocks2:1>,
		<extraplanets:decorative_blocks2:2>,
		<extraplanets:decorative_blocks2:3>,
		<extraplanets:decorative_blocks2:4>,
		<extraplanets:decorative_blocks2:5>,
		<extraplanets:decorative_blocks2:0>,
		<extraplanets:deimos_gravel:0>,
		<extraplanets:deimos:1>,
		<extraplanets:deimos:2>,
		<extraplanets:deimos:3>,
		<extraplanets:deimos:4>,
		<extraplanets:deimos:5>,
		<extraplanets:deimos:0>,
		<extraplanets:dense_ice:0>,
		<extraplanets:diamond_grit:0>,
		<extraplanets:electric_parts:1>,
		<extraplanets:electric_parts:2>,
		<extraplanets:electric_parts:3>,
		<extraplanets:electric_parts:0>,
		<extraplanets:emerald_grit:0>,
		<extraplanets:eris_gravel:0>,
		<extraplanets:eris_spawner:0>,
		<extraplanets:eris_stairs_stone_bricks:0>,
		<extraplanets:eris_stairs_stone:0>,
		<extraplanets:eris_stairs_sub_surface:0>,
		<extraplanets:eris_stairs_surface:0>,
		<extraplanets:eris:1>,
		<extraplanets:eris:2>,
		<extraplanets:eris:3>,
		<extraplanets:eris:4>,
		<extraplanets:eris:5>,
		<extraplanets:eris:6>,
		<extraplanets:eris:7>,
		<extraplanets:eris:8>,
		<extraplanets:eris:9>,
		<extraplanets:eris:0>,
		<extraplanets:europa_gravel:0>,
		<extraplanets:europa:1>,
		<extraplanets:europa:2>,
		<extraplanets:europa:3>,
		<extraplanets:europa:4>,
		<extraplanets:europa:5>,
		<extraplanets:europa:0>,
		<extraplanets:fire_bomb:0>,
		<extraplanets:fossil:0>,
		<extraplanets:frozen_nitrogen:0>,
		<extraplanets:ganymede_gravel:0>,
		<extraplanets:ganymede:1>,
		<extraplanets:ganymede:2>,
		<extraplanets:ganymede:3>,
		<extraplanets:ganymede:4>,
		<extraplanets:ganymede:5>,
		<extraplanets:ganymede:0>,
		<extraplanets:geiger_counter:0>,
		<extraplanets:gold_grit:0>,
		<extraplanets:gravity_controller:0>,
		<extraplanets:green_diamond_axe:*>,
		<extraplanets:green_diamond_boots:*>,
		<extraplanets:green_diamond_chest:*>,
		<extraplanets:green_diamond_helmet:*>,
		<extraplanets:green_diamond_hoe:*>,
		<extraplanets:green_diamond_legings:*>,
		<extraplanets:green_diamond_pickaxe:*>,
		<extraplanets:green_diamond_shovel:*>,
		<extraplanets:green_diamond_sword:*>,
		<extraplanets:iapetus_gravel:0>,
		<extraplanets:iapetus:1>,
		<extraplanets:iapetus:2>,
		<extraplanets:iapetus:3>,
		<extraplanets:iapetus:4>,
		<extraplanets:iapetus:5>,
		<extraplanets:iapetus:6>,
		<extraplanets:iapetus:0>,
		<extraplanets:ingot_mercury:0>,
		<extraplanets:io_gravel:0>,
		<extraplanets:io:1>,
		<extraplanets:io:2>,
		<extraplanets:io:3>,
		<extraplanets:io:4>,
		<extraplanets:io:5>,
		<extraplanets:io:0>,
		<extraplanets:iron_grit:0>,
		<extraplanets:item_tier4_rocket:1>,
		<extraplanets:item_tier4_rocket:2>,
		<extraplanets:item_tier4_rocket:3>,
		<extraplanets:item_tier4_rocket:0>,
		<extraplanets:item_tier5_rocket:1>,
		<extraplanets:item_tier5_rocket:2>,
		<extraplanets:item_tier5_rocket:3>,
		<extraplanets:item_tier5_rocket:0>,
		<extraplanets:item_tier6_rocket:1>,
		<extraplanets:item_tier6_rocket:2>,
		<extraplanets:item_tier6_rocket:3>,
		<extraplanets:item_tier6_rocket:0>,
		<extraplanets:item_tier7_rocket:1>,
		<extraplanets:item_tier7_rocket:2>,
		<extraplanets:item_tier7_rocket:3>,
		<extraplanets:item_tier7_rocket:0>,
		<extraplanets:item_tier8_rocket:1>,
		<extraplanets:item_tier8_rocket:2>,
		<extraplanets:item_tier8_rocket:3>,
		<extraplanets:item_tier8_rocket:0>,
		<extraplanets:item_tier9_rocket:1>,
		<extraplanets:item_tier9_rocket:2>,
		<extraplanets:item_tier9_rocket:3>,
		<extraplanets:item_tier9_rocket:0>,
		<extraplanets:item_tier10_electric_rocket:1>,
		<extraplanets:item_tier10_electric_rocket:2>,
		<extraplanets:item_tier10_electric_rocket:3>,
		<extraplanets:item_tier10_electric_rocket:0>,
		<extraplanets:item_tier10_rocket:1>,
		<extraplanets:item_tier10_rocket:2>,
		<extraplanets:item_tier10_rocket:3>,
		<extraplanets:item_tier10_rocket:0>,
		<extraplanets:jupiter_gravel:0>,
		<extraplanets:jupiter_spawner:0>,
		<extraplanets:jupiter_stairs_stone_bricks:0>,
		<extraplanets:jupiter_stairs_stone:0>,
		<extraplanets:jupiter_stairs_sub_surface:0>,
		<extraplanets:jupiter_stairs_surface:0>,
		<extraplanets:jupiter:1>,
		<extraplanets:jupiter:2>,
		<extraplanets:jupiter:3>,
		<extraplanets:jupiter:4>,
		<extraplanets:jupiter:5>,
		<extraplanets:jupiter:6>,
		<extraplanets:jupiter:7>,
		<extraplanets:jupiter:8>,
		<extraplanets:jupiter:9>,
		<extraplanets:jupiter:10>,
		<extraplanets:jupiter:11>,
		<extraplanets:jupiter:12>,
		<extraplanets:jupiter:13>,
		<extraplanets:jupiter:0>,
		<extraplanets:kepler22b_blue_grass:0>,
		<extraplanets:kepler22b_grass:0>,
		<extraplanets:kepler22b_infected_grass:0>,
		<extraplanets:kepler22b_maple_logs:1>,
		<extraplanets:kepler22b_maple_logs:2>,
		<extraplanets:kepler22b_maple_logs:3>,
		<extraplanets:kepler22b_maple_logs:0>,
		<extraplanets:kepler22b_maple_logs2:1>,
		<extraplanets:kepler22b_maple_logs2:0>,
		<extraplanets:kepler22b_maple_saplings:5>,
		<extraplanets:kepler22b_maple_saplings:4>,
		<extraplanets:kepler22b_maple_saplings:3>,
		<extraplanets:kepler22b_maple_saplings:2>,
		<extraplanets:kepler22b_maple_saplings:1>,
		<extraplanets:kepler22b_maple_saplings:0>,
		<extraplanets:kepler22b_new_maple_leaves_2:1>,
		<extraplanets:kepler22b_new_maple_leaves_2:0>,
		<extraplanets:kepler22b_new_maple_leaves:3>,
		<extraplanets:kepler22b_new_maple_leaves:2>,
		<extraplanets:kepler22b_new_maple_leaves:1>,
		<extraplanets:kepler22b_new_maple_leaves:0>,
		<extraplanets:kepler22b_planks:1>,
		<extraplanets:kepler22b_planks:2>,
		<extraplanets:kepler22b_planks:3>,
		<extraplanets:kepler22b_planks:4>,
		<extraplanets:kepler22b_planks:5>,
		<extraplanets:kepler22b_planks:0>,
		<extraplanets:kepler22b_purple_grass:0>,
		<extraplanets:kepler22b_red_grass:0>,
		<extraplanets:kepler22b_yellow_grass:0>,
		<extraplanets:kepler22b:1>,
		<extraplanets:kepler22b:2>,
		<extraplanets:kepler22b:3>,
		<extraplanets:kepler22b:4>,
		<extraplanets:kepler22b:5>,
		<extraplanets:kepler22b:6>,
		<extraplanets:kepler22b:7>,
		<extraplanets:kepler22b:8>,
		<extraplanets:kepler22b:9>,
		<extraplanets:kepler22b:10>,
		<extraplanets:kepler22b:11>,
		<extraplanets:kepler22b:12>,
		<extraplanets:kepler22b:13>,
		<extraplanets:kepler22b:14>,
		<extraplanets:kepler22b:0>,
		<extraplanets:mars_rover:1>,
		<extraplanets:mars_rover:2>,
		<extraplanets:mars_rover:3>,
		<extraplanets:mars_rover:0>,
		<extraplanets:massive_battery:0>,
		<extraplanets:mercury_battery:0>,
		<extraplanets:mercury_gravel:0>,
		<extraplanets:mercury_spawner:0>,
		<extraplanets:mercury_stairs_stone_bricks:0>,
		<extraplanets:mercury_stairs_stone:0>,
		<extraplanets:mercury_stairs_sub_surface:0>,
		<extraplanets:mercury_stairs_surface:0>,
		<extraplanets:mercury:1>,
		<extraplanets:mercury:2>,
		<extraplanets:mercury:3>,
		<extraplanets:mercury:4>,
		<extraplanets:mercury:5>,
		<extraplanets:mercury:6>,
		<extraplanets:mercury:7>,
		<extraplanets:mercury:8>,
		<extraplanets:mercury:9>,
		<extraplanets:mercury:10>,
		<extraplanets:mercury:11>,
		<extraplanets:mercury:0>,
		<extraplanets:module_items:1>,
		<extraplanets:module_items:2>,
		<extraplanets:module_items:0>,
		<extraplanets:neptune_spawner:0>,
		<extraplanets:neptune_stairs_stone_bricks:0>,
		<extraplanets:neptune_stairs_stone:0>,
		<extraplanets:neptune_stairs_sub_surface:0>,
		<extraplanets:neptune_stairs_surface:0>,
		<extraplanets:neptune:1>,
		<extraplanets:neptune:2>,
		<extraplanets:neptune:3>,
		<extraplanets:neptune:4>,
		<extraplanets:neptune:5>,
		<extraplanets:neptune:6>,
		<extraplanets:neptune:7>,
		<extraplanets:neptune:8>,
		<extraplanets:neptune:9>,
		<extraplanets:neptune:10>,
		<extraplanets:neptune:11>,
		<extraplanets:neptune:0>,
		<extraplanets:nickel_battery:0>,
		<extraplanets:nose_cone_tier4:0>,
		<extraplanets:nose_cone_tier5:0>,
		<extraplanets:nose_cone_tier6:0>,
		<extraplanets:nose_cone_tier7:0>,
		<extraplanets:nose_cone_tier8:0>,
		<extraplanets:nose_cone_tier9:0>,
		<extraplanets:nose_cone_tier10:0>,
		<extraplanets:nuclear_bomb:0>,
		<extraplanets:oberon_gravel:0>,
		<extraplanets:oberon:1>,
		<extraplanets:oberon:2>,
		<extraplanets:oberon:3>,
		<extraplanets:oberon:4>,
		<extraplanets:oberon:5>,
		<extraplanets:oberon:0>,
		<extraplanets:orange_sand:0>,
		<extraplanets:orange_sandstone:0>,
		<extraplanets:oxygen_tank_extremely_heavy_full:9000>,
		<extraplanets:oxygen_tank_extremely_heavy_full:0>,
		<extraplanets:oxygen_tank_heavy_full_black:0>,
		<extraplanets:oxygen_tank_heavy_full_blue:0>,
		<extraplanets:oxygen_tank_heavy_full_brown:0>,
		<extraplanets:oxygen_tank_heavy_full_cyan:0>,
		<extraplanets:oxygen_tank_heavy_full_gray:0>,
		<extraplanets:oxygen_tank_heavy_full_green:0>,
		<extraplanets:oxygen_tank_heavy_full_light_blue:0>,
		<extraplanets:oxygen_tank_heavy_full_light_gray:0>,
		<extraplanets:oxygen_tank_heavy_full_lime:0>,
		<extraplanets:oxygen_tank_heavy_full_magenta:0>,
		<extraplanets:oxygen_tank_heavy_full_orange:0>,
		<extraplanets:oxygen_tank_heavy_full_pink:0>,
		<extraplanets:oxygen_tank_heavy_full_purple:0>,
		<extraplanets:oxygen_tank_heavy_full_white:0>,
		<extraplanets:oxygen_tank_heavy_full_yellow:0>,
		<extraplanets:oxygen_tank_med_full_black:0>,
		<extraplanets:oxygen_tank_med_full_blue:0>,
		<extraplanets:oxygen_tank_med_full_brown:0>,
		<extraplanets:oxygen_tank_med_full_cyan:0>,
		<extraplanets:oxygen_tank_med_full_gray:0>,
		<extraplanets:oxygen_tank_med_full_green:0>,
		<extraplanets:oxygen_tank_med_full_light_blue:0>,
		<extraplanets:oxygen_tank_med_full_light_gray:0>,
		<extraplanets:oxygen_tank_med_full_magenta:0>,
		<extraplanets:oxygen_tank_med_full_pink:0>,
		<extraplanets:oxygen_tank_med_full_purple:0>,
		<extraplanets:oxygen_tank_med_full_red:0>,
		<extraplanets:oxygen_tank_med_full_white:0>,
		<extraplanets:oxygen_tank_med_full_yellow:0>,
		<extraplanets:oxygen_tank_med_full_lime:0>,
		<extraplanets:oxygen_tank_very_heavy_full:7200>,
		<extraplanets:oxygen_tank_very_heavy_full:0>,
		<extraplanets:phobos_gravel:0>,
		<extraplanets:phobos:1>,
		<extraplanets:phobos:2>,
		<extraplanets:phobos:3>,
		<extraplanets:phobos:4>,
		<extraplanets:phobos:5>,
		<extraplanets:phobos:0>,
		<extraplanets:pluto_gravel:0>,
		<extraplanets:pluto_spawner:0>,
		<extraplanets:pluto_stairs_stone_bricks:0>,
		<extraplanets:pluto_stairs_stone:0>,
		<extraplanets:pluto_stairs_sub_surface:0>,
		<extraplanets:pluto_stairs_surface:0>,
		<extraplanets:pluto:1>,
		<extraplanets:pluto:2>,
		<extraplanets:pluto:3>,
		<extraplanets:pluto:4>,
		<extraplanets:pluto:5>,
		<extraplanets:pluto:6>,
		<extraplanets:pluto:7>,
		<extraplanets:pluto:8>,
		<extraplanets:pluto:9>,
		<extraplanets:pluto:0>,
		<extraplanets:purple_diamond_axe:*>,
		<extraplanets:purple_diamond_boots:*>,
		<extraplanets:purple_diamond_chest:*>,
		<extraplanets:purple_diamond_helmet:*>,
		<extraplanets:purple_diamond_hoe:*>,
		<extraplanets:purple_diamond_legings:*>,
		<extraplanets:purple_diamond_pickaxe:*>,
		<extraplanets:purple_diamond_shovel:*>,
		<extraplanets:purple_diamond_sword:*>,
		<extraplanets:red_diamond_axe:*>,
		<extraplanets:red_diamond_boots:*>,
		<extraplanets:red_diamond_chest:*>,
		<extraplanets:red_diamond_helmet:*>,
		<extraplanets:red_diamond_hoe:*>,
		<extraplanets:red_diamond_legings:*>,
		<extraplanets:red_diamond_pickaxe:*>,
		<extraplanets:red_diamond_shovel:*>,
		<extraplanets:red_diamond_sword:*>,
		<extraplanets:red_sand:0>,
		<extraplanets:red_sandstone:0>,
		<extraplanets:rhea_gravel:0>,
		<extraplanets:rhea:1>,
		<extraplanets:rhea:2>,
		<extraplanets:rhea:3>,
		<extraplanets:rhea:4>,
		<extraplanets:rhea:5>,
		<extraplanets:rhea:0>,
		<extraplanets:saturn_gravel:0>,
		<extraplanets:saturn_spawner:0>,
		<extraplanets:saturn_stairs_stone_bricks:0>,
		<extraplanets:saturn_stairs_stone:0>,
		<extraplanets:saturn_stairs_sub_surface:0>,
		<extraplanets:saturn_stairs_surface:0>,
		<extraplanets:saturn:1>,
		<extraplanets:saturn:2>,
		<extraplanets:saturn:3>,
		<extraplanets:saturn:4>,
		<extraplanets:saturn:5>,
		<extraplanets:saturn:6>,
		<extraplanets:saturn:7>,
		<extraplanets:saturn:8>,
		<extraplanets:saturn:9>,
		<extraplanets:saturn:10>,
		<extraplanets:saturn:11>,
		<extraplanets:saturn:12>,
		<extraplanets:saturn:0>,
		<extraplanets:schematic_mars_rover:0>,
		<extraplanets:schematic_tier4:0>,
		<extraplanets:schematic_tier5:0>,
		<extraplanets:schematic_tier6:0>,
		<extraplanets:schematic_tier7:0>,
		<extraplanets:schematic_tier8:0>,
		<extraplanets:schematic_tier9:0>,
		<extraplanets:schematic_tier10_electric_rocket:0>,
		<extraplanets:schematic_tier10:0>,
		<extraplanets:schematic_venus_rover:0>,
		<extraplanets:solar:4>,
		<extraplanets:solar:0>,
		<extraplanets:t4key:0>,
		<extraplanets:t5key:0>,
		<extraplanets:t6key:0>,
		<extraplanets:t7key:0>,
		<extraplanets:t8key:0>,
		<extraplanets:t9key:0>,
		<extraplanets:t10key:0>,
		<extraplanets:thermal_cloth:1>,
		<extraplanets:thermal_cloth:2>,
		<extraplanets:thermal_cloth:0>,
		<extraplanets:tier1_kit:1>,
		<extraplanets:tier1_kit:2>,
		<extraplanets:tier1_kit:3>,
		<extraplanets:tier1_kit:4>,
		<extraplanets:tier1_kit:5>,
		<extraplanets:tier1_kit:0>,
		<extraplanets:tier1_space_suit_gravity_boots:*>,
		<extraplanets:tier1_space_suit_jetpack_chest:*>,
		<extraplanets:tier2_armor_layer:0>,
		<extraplanets:tier2_kit:1>,
		<extraplanets:tier2_kit:2>,
		<extraplanets:tier2_kit:3>,
		<extraplanets:tier2_kit:4>,
		<extraplanets:tier2_kit:5>,
		<extraplanets:tier2_kit:0>,
		<extraplanets:tier2_pressure_layer:0>,
		<extraplanets:tier2_radiation_layer:0>,
		<extraplanets:tier2_space_suit_boots:*>,
		<extraplanets:tier2_space_suit_chest:*>,
		<extraplanets:tier2_space_suit_gravity_boots:*>,
		<extraplanets:tier2_space_suit_helmet:*>,
		<extraplanets:tier2_space_suit_jetpack_chest:*>,
		<extraplanets:tier2_space_suit_legings:*>,
		<extraplanets:tier2_un_prepared_space_suit_boots:*>,
		<extraplanets:tier2_un_prepared_space_suit_chest:*>,
		<extraplanets:tier2_un_prepared_space_suit_helmet:*>,
		<extraplanets:tier2_un_prepared_space_suit_legings:*>,
		<extraplanets:tier3_armor_layer:0>,
		<extraplanets:tier3_kit:1>,
		<extraplanets:tier3_kit:2>,
		<extraplanets:tier3_kit:3>,
		<extraplanets:tier3_kit:4>,
		<extraplanets:tier3_kit:5>,
		<extraplanets:tier3_kit:0>,
		<extraplanets:tier3_pressure_layer:0>,
		<extraplanets:tier3_radiation_layer:0>,
		<extraplanets:tier3_space_suit_boots:*>,
		<extraplanets:tier3_space_suit_chest:*>,
		<extraplanets:tier3_space_suit_gravity_boots:*>,
		<extraplanets:tier3_space_suit_helmet:*>,
		<extraplanets:tier3_space_suit_jetpack_chest:*>,
		<extraplanets:tier3_space_suit_legings:*>,
		<extraplanets:tier3_thermal_padding:1>,
		<extraplanets:tier3_thermal_padding:2>,
		<extraplanets:tier3_thermal_padding:3>,
		<extraplanets:tier3_thermal_padding:0>,
		<extraplanets:tier3_un_prepared_space_suit_boots:*>,
		<extraplanets:tier3_un_prepared_space_suit_chest:*>,
		<extraplanets:tier3_un_prepared_space_suit_helmet:*>,
		<extraplanets:tier3_un_prepared_space_suit_legings:*>,
		<extraplanets:tier4_armor_layer:0>,
		<extraplanets:tier4_items:1>,
		<extraplanets:tier4_items:2>,
		<extraplanets:tier4_items:3>,
		<extraplanets:tier4_items:4>,
		<extraplanets:tier4_items:5>,
		<extraplanets:tier4_items:6>,
		<extraplanets:tier4_items:0>,
		<extraplanets:tier4_kit:1>,
		<extraplanets:tier4_kit:2>,
		<extraplanets:tier4_kit:3>,
		<extraplanets:tier4_kit:4>,
		<extraplanets:tier4_kit:5>,
		<extraplanets:tier4_kit:0>,
		<extraplanets:tier4_pressure_layer:0>,
		<extraplanets:tier4_radiation_layer:0>,
		<extraplanets:tier4_space_suit_boots:*>,
		<extraplanets:tier4_space_suit_chest:*>,
		<extraplanets:tier4_space_suit_gravity_boots:*>,
		<extraplanets:tier4_space_suit_helmet:*>,
		<extraplanets:tier4_space_suit_jetpack_chest:*>,
		<extraplanets:tier4_space_suit_legings:*>,
		<extraplanets:tier4_thermal_padding:1>,
		<extraplanets:tier4_thermal_padding:2>,
		<extraplanets:tier4_thermal_padding:3>,
		<extraplanets:tier4_thermal_padding:0>,
		<extraplanets:tier4_un_prepared_space_suit_boots:*>,
		<extraplanets:tier4_un_prepared_space_suit_chest:*>,
		<extraplanets:tier4_un_prepared_space_suit_helmet:*>,
		<extraplanets:tier4_un_prepared_space_suit_legings:*>,
		<extraplanets:tier5_items:1>,
		<extraplanets:tier5_items:2>,
		<extraplanets:tier5_items:3>,
		<extraplanets:tier5_items:4>,
		<extraplanets:tier5_items:5>,
		<extraplanets:tier5_items:6>,
		<extraplanets:tier5_items:8>,
		<extraplanets:tier5_items:9>,
		<extraplanets:tier5_items:10>,
		<extraplanets:tier5_items:11>,
		<extraplanets:tier5_items:12>,
		<extraplanets:tier5_items:0>,
		<extraplanets:tier5_kit:1>,
		<extraplanets:tier5_kit:2>,
		<extraplanets:tier5_kit:3>,
		<extraplanets:tier5_kit:4>,
		<extraplanets:tier5_kit:5>,
		<extraplanets:tier5_kit:0>,
		<extraplanets:tier5_thermal_padding:1>,
		<extraplanets:tier5_thermal_padding:2>,
		<extraplanets:tier5_thermal_padding:3>,
		<extraplanets:tier5_thermal_padding:0>,
		<extraplanets:tier6_items:1>,
		<extraplanets:tier6_items:2>,
		<extraplanets:tier6_items:3>,
		<extraplanets:tier6_items:4>,
		<extraplanets:tier6_items:5>,
		<extraplanets:tier6_items:0>,
		<extraplanets:tier7_items:1>,
		<extraplanets:tier7_items:2>,
		<extraplanets:tier7_items:3>,
		<extraplanets:tier7_items:4>,
		<extraplanets:tier7_items:5>,
		<extraplanets:tier7_items:6>,
		<extraplanets:tier7_items:7>,
		<extraplanets:tier7_items:0>,
		<extraplanets:tier8_items:1>,
		<extraplanets:tier8_items:2>,
		<extraplanets:tier8_items:3>,
		<extraplanets:tier8_items:4>,
		<extraplanets:tier8_items:5>,
		<extraplanets:tier8_items:6>,
		<extraplanets:tier8_items:0>,
		<extraplanets:tier9_items:1>,
		<extraplanets:tier9_items:2>,
		<extraplanets:tier9_items:3>,
		<extraplanets:tier9_items:4>,
		<extraplanets:tier9_items:5>,
		<extraplanets:tier9_items:0>,
		<extraplanets:tier10_items:1>,
		<extraplanets:tier10_items:2>,
		<extraplanets:tier10_items:3>,
		<extraplanets:tier10_items:4>,
		<extraplanets:tier10_items:5>,
		<extraplanets:tier10_items:0>,
		<extraplanets:tier11_items:1>,
		<extraplanets:tier11_items:2>,
		<extraplanets:tier11_items:3>,
		<extraplanets:tier11_items:4>,
		<extraplanets:tier11_items:0>,
		<extraplanets:titan_gravel:0>,
		<extraplanets:titan:1>,
		<extraplanets:titan:2>,
		<extraplanets:titan:3>,
		<extraplanets:titan:4>,
		<extraplanets:titan:5>,
		<extraplanets:titan:6>,
		<extraplanets:titan:7>,
		<extraplanets:titan:8>,
		<extraplanets:titan:0>,
		<extraplanets:titania_gravel:0>,
		<extraplanets:titania:1>,
		<extraplanets:titania:2>,
		<extraplanets:titania:3>,
		<extraplanets:titania:4>,
		<extraplanets:titania:5>,
		<extraplanets:titania:0>,
		<extraplanets:tools:1>,
		<extraplanets:tools:2>,
		<extraplanets:tools:3>,
		<extraplanets:tools:0>,
		<extraplanets:treasure_chest_t4:0>,
		<extraplanets:treasure_chest_t5:0>,
		<extraplanets:treasure_chest_t6:0>,
		<extraplanets:treasure_chest_t7:0>,
		<extraplanets:treasure_chest_t8:0>,
		<extraplanets:treasure_chest_t9:0>,
		<extraplanets:treasure_chest_t10:0>,
		<extraplanets:triton_gravel:0>,
		<extraplanets:triton:1>,
		<extraplanets:triton:2>,
		<extraplanets:triton:3>,
		<extraplanets:triton:4>,
		<extraplanets:triton:5>,
		<extraplanets:triton:0>,
		<extraplanets:ultimate_battery:0>,
		<extraplanets:ultimate_fuel_loader:0>,
		<extraplanets:ultimate_oxygen_compressor:4>,
		<extraplanets:ultimate_oxygen_compressor:0>,
		<extraplanets:uranus_spawner:0>,
		<extraplanets:uranus_stairs_stone_bricks:0>,
		<extraplanets:uranus_stairs_stone:0>,
		<extraplanets:uranus_stairs_sub_surface:0>,
		<extraplanets:uranus_stairs_surface:0>,
		<extraplanets:uranus:1>,
		<extraplanets:uranus:2>,
		<extraplanets:uranus:3>,
		<extraplanets:uranus:4>,
		<extraplanets:uranus:5>,
		<extraplanets:uranus:6>,
		<extraplanets:uranus:7>,
		<extraplanets:uranus:8>,
		<extraplanets:uranus:0>,
		<extraplanets:vehicle_charger:0>,
		<extraplanets:venus_rover:1>,
		<extraplanets:venus_rover:2>,
		<extraplanets:venus_rover:3>,
		<extraplanets:venus_rover:0>,
		<extraplanets:volcanic_rock:0>,
		<extraplanets:white_sugar_cane_item:0>,
		<extraplanets:white_sugar_cane:0>,
		<extraplanets:yellow_diamond_axe:*>,
		<extraplanets:yellow_diamond_boots:*>,
		<extraplanets:yellow_diamond_chest:*>,
		<extraplanets:yellow_diamond_helmet:*>,
		<extraplanets:yellow_diamond_hoe:*>,
		<extraplanets:yellow_diamond_legings:*>,
		<extraplanets:yellow_diamond_pickaxe:*>,
		<extraplanets:yellow_diamond_shovel:*>,
		<extraplanets:yellow_diamond_sword:*>,
		<extraplanets:zinc_battery:0>
	],

	stageCreativeUnused.stage: [
		<extraplanets:item_tier10_electric_rocket:4>,
		<extraplanets:item_tier10_rocket:4>,
		<extraplanets:item_tier4_rocket:4>,
		<extraplanets:item_tier5_rocket:4>,
		<extraplanets:item_tier6_rocket:4>,
		<extraplanets:item_tier7_rocket:4>,
		<extraplanets:item_tier8_rocket:4>,
		<extraplanets:item_tier9_rocket:4>
	]
};

static hiddenRemove as IIngredient[] = [
	<extraplanets:advanced_refinery:0>,
	<extraplanets:apple_diamond:0>,
	<extraplanets:block_multi:0>,
	<extraplanets:ultimate_refinery:0>,
	<extraplanets:wafer:0>,
	<extraplanets:wafer:1>,
	<extraplanets:wafer:2>,
	<extraplanets:wafer:3>,
	<extraplanets:wafer:4>,
	<extraplanets:wafer:5>
];

static hidden as IIngredient[] = [
	<extraplanets:kepler22b_flowers:0>,
	<extraplanets:kepler22b_flowers:1>,
	<extraplanets:kepler22b_flowers:2>,
	<extraplanets:kepler22b_flowers:3>,
	<extraplanets:kepler22b_flowers:4>,
	<extraplanets:kepler22b_flowers:5>
];

function init() {
	var modId as string = stagedItems.entrySet[0].value[0].items[0].definition.owner;

	var modStage as string = scripts.crafttweaker.staging.itemsAndRecipes.modId.containsMod(modId);
	var doOverride as bool = modStage != "";

	for stageName, items in stagedItems {
		if (doOverride && stageName != modStage) {
			ZenStager.addModItemOverrides(modId, items);
		}

		ZenStager.getStage(stageName).addIngredients(items);
	}
	recipeUtil.hideItems(hiddenRemove as IIngredient[], true);
	recipeUtil.hideItems(hidden as IIngredient[], false);
}
