/* 
BSL Shaders v7.1.05 by Capt Tatsu 
https://bitslablab.com 
*/ 

//Settings//
#include "/lib/settings.glsl"

//Fragment Shader///////////////////////////////////////////////////////////////////////////////////
#ifdef FSH

//Extensions//

//Varyings//
varying float isMainHand;

varying vec2 texCoord, lmCoord;

varying vec3 normal;
varying vec3 sunVec, upVec;

varying vec4 color;

#ifdef ADVANCEDMATERIALS
varying float dist;

varying vec3 binormal, tangent;
varying vec3 viewVector;

varying vec4 vTexCoord, vTexCoordAM;
#endif

//Uniforms//
uniform int frameCounter;
uniform int heldItemId, heldItemId2;
uniform int isEyeInWater;
uniform int worldTime;

uniform float frameTimeCounter;
uniform float nightVision;
uniform float rainStrength;
uniform float screenBrightness; 
uniform float shadowFade;
uniform float timeAngle, timeBrightness;
uniform float viewWidth, viewHeight;

uniform ivec2 eyeBrightnessSmooth;

uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;

uniform sampler2D texture;

#ifdef ADVANCEDMATERIALS
uniform sampler2D specular;
uniform sampler2D normals;
#endif

//Common Variables//
float eBS = eyeBrightnessSmooth.y / 240.0;
float sunVisibility  = clamp(dot( sunVec,upVec) + 0.05, 0.0, 0.1) * 10.0;
float moonVisibility = clamp(dot(-sunVec,upVec) + 0.05, 0.0, 0.1) * 10.0;

#ifdef WORLD_TIME_ANIMATION
float frametime = float(worldTime) * 0.05 * ANIMATION_SPEED;
#else
float frametime = frameTimeCounter * ANIMATION_SPEED;
#endif

#ifdef ADVANCEDMATERIALS
vec2 dcdx = dFdx(texCoord.xy);
vec2 dcdy = dFdy(texCoord.xy);
#endif

vec3 lightVec = sunVec * ((timeAngle < 0.5325 || timeAngle > 0.9675) ? 1.0 : -1.0);

//Common Functions//
float GetLuminance(vec3 color){
	return dot(color,vec3(0.299, 0.587, 0.114));
}

float InterleavedGradientNoise(){
	float n = 52.9829189 * fract(0.06711056 * gl_FragCoord.x + 0.00583715 * gl_FragCoord.y);
	return fract(n + frameCounter / 8.0);
}

//Includes//
#include "/lib/color/blocklightColor.glsl"
#include "/lib/color/dimensionColor.glsl"
#include "/lib/util/spaceConversion.glsl"
#include "/lib/visual/lighting.glsl"

#if AA == 2
#include "/lib/util/jitter.glsl"
#endif

#ifdef ADVANCEDMATERIALS
#include "/lib/util/encode.glsl"
#include "/lib/rps/ggx.glsl"
#include "/lib/rps/materialGbuffers.glsl"
#include "/lib/rps/parallax.glsl"
#endif

//Program//
void main(){
    vec4 albedo = texture2D(texture, texCoord) * color;

	#ifdef ADVANCEDMATERIALS
	vec2 newCoord = vTexCoord.st * vTexCoordAM.pq + vTexCoordAM.st;
	float skipParallax = float(heldItemId  == 358 || (heldItemId2 == 358 && isMainHand  < 0.5));
	
	#ifdef PARALLAX
	if(skipParallax < 0.5){
		newCoord = GetParallaxCoord(0.0);
		albedo = texture2DGradARB(texture, newCoord, dcdx, dcdy) * color;
	}
	#endif

	float smoothness = 0.0, metalData = 0.0, skymapMod = 0.0;
	vec3 rawAlbedo = vec3(0.0);
	#endif

	vec3 newNormal = normal;
	float emissive = 0.0;

	if(albedo.a > 0.1){
		#ifdef TOON_LIGHTMAP
		vec2 lightmap = clamp(floor(lmCoord * 14.999 * (0.75 + 0.25 * color.a)) / 14, 0.0, 1.0);
		#else
		vec2 lightmap = clamp(lmCoord, vec2(0.0), vec2(1.0));
		#endif

		vec3 screenPos = vec3(gl_FragCoord.xy / vec2(viewWidth, viewHeight), gl_FragCoord.z + 0.38);
		#if AA == 2
		vec3 viewPos = ToNDC(vec3(TAAJitter(screenPos.xy,-0.5),screenPos.z));
		#else
		vec3 viewPos = ToNDC(screenPos);
		#endif
		vec3 worldPos = ToWorld(viewPos);

		#ifdef ADVANCEDMATERIALS
		float metalness = 0.0, f0 = 0.0, ao = 1.0;
		vec3 normalMap = vec3(0.0);
		GetMaterials(smoothness, metalness, f0, metalData, emissive, ao, normalMap,
					 newCoord, dcdx, dcdy);
		
		mat3 tbnMatrix = mat3(tangent.x, binormal.x, normal.x,
							  tangent.y, binormal.y, normal.y,
							  tangent.z, binormal.z, normal.z);

		float normalCheck = normalMap.x + normalMap.y;
		if (normalCheck > -1.999)
			newNormal = clamp(normalize(normalMap * tbnMatrix), vec3(-1.0), vec3(1.0));
		#endif

		float doRecolor = float((heldItemId  ==  89 || heldItemId   == 138 || heldItemId   == 169 ||
		                         heldItemId  == 213) && isMainHand > 0.5);
			  doRecolor+= float((heldItemId2 ==  89 || heldItemId2  == 138 || heldItemId2  == 169 ||
								 heldItemId2 == 213) && isMainHand < 0.5);
		#ifdef EMISSIVE_RECOLOR
		if (doRecolor > 0.5){
			float ec = length(albedo.rgb);
			albedo.rgb = blocklightCol * (ec * 0.3 / BLOCKLIGHT_I) + ec * 0.3;
		}
		#else
		if (doRecolor > 0.5) albedo.rgb *=  0.7;
		#endif

    	albedo.rgb = pow(albedo.rgb, vec3(2.2));
		albedo.a = albedo.a * 0.5 + 0.5;

		#ifdef WHITE_WORLD
		albedo.rgb = vec3(0.5);
		#endif

		float NdotL = clamp(dot(newNormal, lightVec) * 1.01 - 0.01, 0.0, 1.0);

		float quarterNdotU = clamp(0.25 * dot(newNormal, upVec) + 0.75, 0.5, 1.0);
			  quarterNdotU*= quarterNdotU;

		#ifdef ADVANCEDMATERIALS
		rawAlbedo = albedo.rgb * 0.999 + 0.001;
		if(normalCheck > -1.999) albedo.rgb *= ao;

		#ifdef REFLECTION_SPECULAR
		float roughnessSqr = (1.0 - smoothness) * sqrt(1.0 - smoothness);
		if(normalCheck > -1.999) albedo.rgb *= (1.0 - metalness * (1.0 - roughnessSqr));
		#endif

		float parallaxShadow = 1.0, doParallax = 0.0;
		#ifdef SELF_SHADOW
		#ifdef OVERWORLD
		doParallax = float(lightmap.y > 0.0 && NdotL > 0.0 && skipParallax < 0.5);
		#endif
		#ifdef END
		doParallax = float(NdotL > 0.0 && skipParallax < 0.5);
		#endif
		
		if(doParallax > 0.5){
			parallaxShadow = GetParallaxShadow(0.0, newCoord, lightVec, tbnMatrix);
			NdotL *= parallaxShadow;
		}
		#endif
		#endif
		
		vec3 shadow = vec3(0.0);
		GetLighting(albedo.rgb, shadow, viewPos, worldPos, lightmap, 1.0, NdotL, quarterNdotU,
				    emissive, 0.0);

		#ifdef ADVANCEDMATERIALS
		skymapMod = lightmap.y * lightmap.y * (3.0 - 2.0 * lightmap.y);
		shadow *= parallaxShadow;

		#if defined OVERWORLD || defined END
		if(dot(shadow, shadow) > 0.001){
			float specular = GGX(newNormal, normalize(viewPos), lightVec,
				                 smoothness, f0, 0.025 * sunVisibility + 0.05);
			specular *= (1.0 - sqrt(rainStrength)) * shadowFade;

			#ifdef OVERWORLD
			vec3 lightME = mix(lightMorning, lightEvening, mefade);
			vec3 lightDayTint = lightDay * lightME * LIGHT_DI;
			vec3 lightDaySpec = mix(lightME, sqrt(lightDayTint), timeBrightness);
			vec3 specularColor = mix(sqrt(lightNight),
										lightDaySpec,
										sunVisibility);
			specularColor *= specularColor;
			#endif
			#ifdef END
			vec3 specularColor = endCol;
			#endif
			
			specularColor = pow(specularColor, vec3(1.0 - 0.5 * metalness));
			#if MATERIAL_FORMAT == 0
			if(metalness > 0.5){
				if(f0 < 1.0) specularColor *= GetMetalCol(f0);
				else specularColor *= rawAlbedo;
			}
			#else
			specularColor *= pow(rawAlbedo, vec3(metalness));
			#endif
			
			albedo.rgb += specular * specularColor * shadow;
		}
		#endif

		#if defined REFLECTION_SPECULAR && defined REFLECTION_ROUGH
		normalMap = mix(vec3(0.0, 0.0, 1.0), normalMap, smoothness);
		if (normalCheck > -1.999)
			newNormal = clamp(normalize(normalMap * tbnMatrix), vec3(-1.0), vec3(1.0));
		#endif
		#endif
	}

    /* DRAWBUFFERS:0 */
    gl_FragData[0] = albedo;

	#if defined ADVANCEDMATERIALS && defined REFLECTION_SPECULAR
	/* DRAWBUFFERS:0367 */
	gl_FragData[1] = vec4(smoothness, metalData, skymapMod, 1.0);
	gl_FragData[2] = vec4(EncodeNormal(newNormal), float(gl_FragCoord.z < 1.0), 1.0);
	gl_FragData[3] = vec4(rawAlbedo, 1.0);
	#endif
}

#endif

//Vertex Shader/////////////////////////////////////////////////////////////////////////////////////
#ifdef VSH

//Varyings//
varying float isMainHand;

varying vec2 texCoord, lmCoord;

varying vec3 normal;
varying vec3 sunVec, upVec;

varying vec4 color;

#ifdef ADVANCEDMATERIALS
varying float dist;

varying vec3 binormal, tangent;
varying vec3 viewVector;

varying vec4 vTexCoord, vTexCoordAM;
#endif

//Uniforms//
uniform int worldTime;

uniform float frameTimeCounter;
uniform float timeAngle;

uniform vec3 cameraPosition;

uniform mat4 gbufferModelView, gbufferModelViewInverse;

#if AA == 2
uniform int frameCounter;

uniform float viewWidth, viewHeight;
#endif

//Attributes//
attribute vec4 mc_Entity;

#ifdef ADVANCEDMATERIALS
attribute vec4 mc_midTexCoord;
attribute vec4 at_tangent;
#endif

//Common Variables//
#ifdef WORLD_TIME_ANIMATION
float frametime = float(worldTime) * 0.05 * ANIMATION_SPEED;
#else
float frametime = frameTimeCounter * ANIMATION_SPEED;
#endif

//Includes//
#if AA == 2
#include "/lib/util/jitter.glsl"
#endif

//Program//
void main(){
	texCoord = gl_MultiTexCoord0.xy;
    
	lmCoord = (gl_TextureMatrix[1] * gl_MultiTexCoord1).xy;
	lmCoord = clamp((lmCoord - 0.03125) * 1.06667, 0.0, 1.0);

	normal = normalize(gl_NormalMatrix * gl_Normal);

	#ifdef ADVANCEDMATERIALS
	binormal = normalize(gl_NormalMatrix * cross(at_tangent.xyz, gl_Normal.xyz) * at_tangent.w);
	tangent  = normalize(gl_NormalMatrix * at_tangent.xyz);
	
	mat3 tbnMatrix = mat3(tangent.x, binormal.x, normal.x,
						  tangent.y, binormal.y, normal.y,
						  tangent.z, binormal.z, normal.z);
								  
	viewVector = tbnMatrix * (gl_ModelViewMatrix * gl_Vertex).xyz;
	
	dist = length(gl_ModelViewMatrix * gl_Vertex);

	vec2 midCoord = (gl_TextureMatrix[0] *  mc_midTexCoord).st;
	vec2 texMinMidCoord = texCoord - midCoord;

	vTexCoordAM.pq  = abs(texMinMidCoord) * 2;
	vTexCoordAM.st  = min(texCoord, midCoord - texMinMidCoord);
	
	vTexCoord.xy    = sign(texMinMidCoord) * 0.5 + 0.5;
	#endif
    
	color = gl_Color;

	isMainHand = float(gl_ModelViewMatrix[3][0] > 0.0);

	const vec2 sunRotationData = vec2(cos(sunPathRotation * 0.01745329251994), -sin(sunPathRotation * 0.01745329251994));
	float ang = fract(timeAngle - 0.25);
	ang = (ang + (cos(ang * 3.14159265358979) * -0.5 + 0.5 - ang) / 3.0) * 6.28318530717959;
	sunVec = normalize((gbufferModelView * vec4(vec3(-sin(ang), cos(ang) * sunRotationData) * 2000.0, 1.0)).xyz);

	upVec = normalize(gbufferModelView[1].xyz);

	gl_Position = ftransform();
	
	#if AA == 2
	gl_Position.xy = TAAJitter(gl_Position.xy, gl_Position.w);
	#endif
}

#endif